/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class BalanceChecker {
    public static final String ETHERSCAN_API_KEY = Config.ETHERSCAN_API_KEY;
    private static final String BITCOIN_API_URL = "https://blockstream.info/api/address/";
    private static final String TRON_API_URL = "https://api.trongrid.io/v1/accounts/";
    private static final String RIPPLE_PUBLIC_NODE_URL = "https://s1.ripple.com:51234/";
    private static final String SOLANA_RPC_URL = "https://api.mainnet-beta.solana.com";
    private static final String SOLANA_USDC_MINT = "Es9vMFrzaCERz8rNzLoKf7fYTTTuCyJ6M1L3REjwrwN9";
    private static final String SOLANA_USDT_MINT = "BQvE93T3z5i9mKjMAowPxnYd6cAxr7Br6iQ8JdKc6fGL";
    private static final String SOLANA_WBTC_MINT = "7dHbWXU5thGfpZ3sXtcLVEFSvfUNkBEy3Rzk8yqPztvU";
    private static final String SOLANA_BONK_MINT = "DezXz1BD5bVh1xZV3gH5si3fZfrsnPhXHQDtY6YtFQdA";

    public static BigDecimal getBTCBalance(String string) throws Exception {
        URI uRI = new URI(BITCOIN_API_URL + string);
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        String string2 = httpResponse.body();
        JSONObject jSONObject = new JSONObject(string2);
        JSONObject jSONObject2 = jSONObject.getJSONObject("chain_stats");
        long l = jSONObject2.optLong("funded_txo_sum", 0L);
        long l2 = jSONObject2.optLong("spent_txo_sum", 0L);
        BigDecimal bigDecimal = new BigDecimal("100000000");
        BigDecimal bigDecimal2 = new BigDecimal(l - l2).divide(bigDecimal, 8, 1);
        return bigDecimal2;
    }

    public static BigDecimal getETHBalance(String string) throws Exception {
        HttpRequest httpRequest;
        URI uRI = new URI("https://api.etherscan.io/api?module=account&action=balance&address=" + string + "&tag=latest&apikey=" + ETHERSCAN_API_KEY);
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build(), HttpResponse.BodyHandlers.ofString());
        JSONObject jSONObject = new JSONObject(httpResponse.body());
        if (!"1".equals(jSONObject.optString("status"))) {
            throw new Exception("Etherscan error: " + jSONObject.optString("message", "Unknown error"));
        }
        String string2 = jSONObject.getString("result");
        BigDecimal bigDecimal = new BigDecimal(string2);
        BigDecimal bigDecimal2 = new BigDecimal("1000000000000000000");
        return bigDecimal.divide(bigDecimal2, 18, 1);
    }

    public static BigDecimal getERC20TokenBalance(String string, String string2, int n) throws Exception {
        String string3 = "https://api.etherscan.io/api?module=account&action=tokenbalance&contractaddress=" + string2 + "&address=" + string + "&tag=latest&apikey=" + ETHERSCAN_API_KEY;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(string3)).GET().build();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        JSONObject jSONObject = new JSONObject(httpResponse.body());
        if (!"1".equals(jSONObject.optString("status"))) {
            throw new Exception("Etherscan error: " + jSONObject.optString("message", "Unknown error"));
        }
        String string4 = jSONObject.getString("result");
        BigDecimal bigDecimal = new BigDecimal(string4);
        BigDecimal bigDecimal2 = BigDecimal.TEN.pow(n);
        return bigDecimal.divide(bigDecimal2, n, 1);
    }

    public static BigDecimal getEthereumUSDTBalance(String string) throws Exception {
        return BalanceChecker.getERC20TokenBalance(string, "0xdAC17F958D2ee523a2206206994597C13D831ec7", 6);
    }

    public static BigDecimal getEthereumUSDCBalance(String string) throws Exception {
        return BalanceChecker.getERC20TokenBalance(string, "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48", 6);
    }

    public static BigDecimal getEthereumBNBBalance(String string) throws Exception {
        return BalanceChecker.getERC20TokenBalance(string, "0xB8c77482e45F1F44dE1745F52C74426C631bDD52", 18);
    }

    public static Map<String, BigDecimal> getAllERC20TokenBalances(String string) throws Exception {
        Map<String, String> map = Map.of("USDT", "0xdAC17F958D2ee523a2206206994597C13D831ec7", "DAI", "0x6B175474E89094C44Da98b954EedeAC495271d0F", "USDC", "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eb48");
        Map<String, Integer> map2 = Map.of("USDT", 6, "DAI", 18, "USDC", 6);
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        for (String string2 : map.keySet()) {
            String string3 = map.get(string2);
            int n = map2.getOrDefault(string2, 18);
            String string4 = "https://api.etherscan.io/api?module=account&action=tokenbalance&contractaddress=" + string3 + "&address=" + string + "&tag=latest&apikey=" + ETHERSCAN_API_KEY;
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(string4)).GET().build();
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            JSONObject jSONObject = new JSONObject(httpResponse.body());
            if (!"1".equals(jSONObject.optString("status"))) continue;
            String string5 = jSONObject.getString("result");
            BigDecimal bigDecimal = new BigDecimal(string5);
            BigDecimal bigDecimal2 = BigDecimal.TEN.pow(n);
            BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, n, 1);
            hashMap.put(string2, bigDecimal3);
        }
        return hashMap;
    }

    public static BigDecimal getTronBalance(String string) throws Exception {
        URI uRI = new URI(TRON_API_URL + string);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        JSONObject jSONObject = new JSONObject(httpResponse.body());
        if (!jSONObject.optBoolean("success", false)) {
            throw new Exception("Unable to access TRON API.");
        }
        JSONArray jSONArray = jSONObject.optJSONArray("data");
        if (jSONArray == null || jSONArray.isEmpty()) {
            return BigDecimal.ZERO;
        }
        JSONObject jSONObject2 = jSONObject.getJSONArray("data").getJSONObject(0);
        String string2 = jSONObject.optString("balance", "0");
        BigInteger bigInteger = new BigInteger(string2);
        BigDecimal bigDecimal = new BigDecimal(bigInteger).divide(BigDecimal.valueOf(1000000L));
        return bigDecimal;
    }

    public static BigDecimal getTronTokenBalanceByContract(String string, String string2) throws Exception {
        String string3 = TRON_API_URL + string;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string3)).header("Accept", "application/json").build();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        JSONObject jSONObject = new JSONObject(httpResponse.body());
        if (!jSONObject.has("data") || jSONObject.getJSONArray("data").isEmpty()) {
            return BigDecimal.ZERO;
        }
        JSONObject jSONObject2 = jSONObject.getJSONArray("data").getJSONObject(0);
        if (!jSONObject2.has("trc20")) {
            return BigDecimal.ZERO;
        }
        JSONArray jSONArray = jSONObject2.getJSONArray("trc20");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject3 = jSONArray.getJSONObject(i);
            if (!jSONObject3.has(string2)) continue;
            String string4 = jSONObject3.getString(string2);
            return new BigDecimal(string4);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getTronUSDTBalance(String string) throws Exception {
        BigDecimal bigDecimal = BalanceChecker.getTronTokenBalanceByContract(string, "TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t");
        return bigDecimal.movePointLeft(6);
    }

    public static BigDecimal getTronUSDCBalance(String string) throws Exception {
        BigDecimal bigDecimal = BalanceChecker.getTronTokenBalanceByContract(string, "TLZSucJRjnqBKwvQz6n5hd29gbS4P7u7w8");
        return bigDecimal.movePointLeft(6);
    }

    public static BigDecimal getTronBNBBalance(String string) throws Exception {
        BigDecimal bigDecimal = BalanceChecker.getTronTokenBalanceByContract(string, "TDgkC3ZZBgaDqkteSgx9F14rPfqRgktyzh");
        return bigDecimal.movePointLeft(8);
    }

    public static Map<String, BigDecimal> getAllTRC20TokenBalances(String string) throws Exception {
        Object object;
        Map<String, String> map = Map.of("USDT", "TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t", "USDC", "TLZSucJRjnqBKwvQz6n5hd29gbS4P7u7w8", "BNB", "TDgkC3ZZBgaDqkteSgx9F14rPfqRgktyzh");
        Map<String, Integer> map2 = Map.of("USDT", 6, "USDC", 6, "BNB", 8);
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        String string2 = TRON_API_URL + string;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string2)).header("Accept", "application/json").build();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        JSONObject jSONObject = new JSONObject(httpResponse.body());
        JSONArray jSONArray = new JSONArray();
        if (jSONObject.has("data") && !jSONObject.getJSONArray("data").isEmpty() && ((JSONObject)(object = jSONObject.getJSONArray("data").getJSONObject(0))).has("trc20")) {
            jSONArray = ((JSONObject)object).getJSONArray("trc20");
        }
        object = new HashMap();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject object2 = jSONArray.getJSONObject(i);
            for (String string3 : object2.keySet()) {
                object.put(string3, new BigDecimal(object2.getString(string3)));
            }
        }
        for (String string4 : map.keySet()) {
            String string5 = map.get(string4);
            int n = map2.getOrDefault(string4, 6);
            BigDecimal bigDecimal = object.getOrDefault(string5, BigDecimal.ZERO);
            BigDecimal bigDecimal2 = bigDecimal.movePointLeft(n);
            hashMap.put(string4, bigDecimal2);
        }
        return hashMap;
    }

    public static Map<String, BigDecimal> getAllXRPTokens(String string) throws Exception {
        Object object;
        Map<String, String> map = Map.of("USD.Bitstamp", "rhub8VRN55s94qWKDv6jmDy1pUykJzF3wq", "BTC.Bitso", "rKiCet8SdvWxPXnAgYarFUXMh1zCPz432Y", "EUR.Gatehub", "rhub8VRN55s94qWKDv6jmDy1pUykJzF3wq");
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        String string2 = RIPPLE_PUBLIC_NODE_URL;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("method", "account_lines");
        jSONObject.put("params", List.of(new JSONObject().put("account", string).put("limit", 100)));
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string2)).POST(HttpRequest.BodyPublishers.ofString(jSONObject.toString())).header("Content-Type", "application/json").build();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        JSONObject jSONObject2 = new JSONObject(httpResponse.body());
        HashMap<CallSite, BigDecimal> hashMap2 = new HashMap<CallSite, BigDecimal>();
        if (jSONObject2.has("result") && ((JSONObject)(object = jSONObject2.getJSONObject("result"))).has("lines")) {
            JSONArray object2 = ((JSONObject)object).getJSONArray("lines");
            for (int i = 0; i < object2.length(); ++i) {
                JSONObject jSONObject3 = object2.getJSONObject(i);
                String string3 = jSONObject3.getString("currency");
                String string4 = jSONObject3.getString("account");
                String string5 = jSONObject3.getString("balance");
                String string6 = string3 + "." + string4;
                hashMap2.put((CallSite)((Object)string6), new BigDecimal(string5));
            }
        }
        for (String string7 : map.keySet()) {
            BigDecimal bigDecimal = hashMap2.getOrDefault(string7, BigDecimal.ZERO);
            hashMap.put(string7, bigDecimal);
        }
        return hashMap;
    }

    public static BigDecimal getXRPBalance(String string) throws Exception {
        Object object;
        Object object2;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("method", "account_info");
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("account", string);
        jSONObject2.put("ledger_index", "validated");
        jSONArray.put(jSONObject2);
        jSONObject.put("params", jSONArray);
        URL uRL = new URL(RIPPLE_PUBLIC_NODE_URL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setDoOutput(true);
        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
            object2 = jSONObject.toString().getBytes("utf-8");
            outputStream.write((byte[])object2, 0, ((byte[])object2).length);
        }
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            throw new RuntimeException("Failed to get balance. HTTP error code: " + n);
        }
        object2 = new StringBuilder();
        try (Object object3 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "utf-8"));){
            while ((object = ((BufferedReader)object3).readLine()) != null) {
                ((StringBuilder)object2).append(((String)object).trim());
            }
        }
        object3 = new JSONObject(((StringBuilder)object2).toString());
        object = ((JSONObject)object3).optJSONObject("result");
        if (object == null) {
            return BigDecimal.ZERO;
        }
        JSONObject jSONObject3 = ((JSONObject)object).optJSONObject("account_data");
        if (jSONObject3 == null) {
            return BigDecimal.ZERO;
        }
        String string2 = jSONObject3.optString("Balance", "0");
        BigDecimal bigDecimal = new BigDecimal(string2).movePointLeft(6);
        return bigDecimal;
    }

    public static BigDecimal getSOLBalance(String string) throws Exception {
        String string2 = SOLANA_RPC_URL;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("jsonrpc", "2.0");
        jSONObject.put("id", 1);
        jSONObject.put("method", "getBalance");
        jSONObject.put("params", new JSONArray().put(string));
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setDoOutput(true);
        try (Object object = httpURLConnection.getOutputStream();){
            ((OutputStream)object).write(jSONObject.toString().getBytes());
            ((OutputStream)object).flush();
        }
        object = new StringBuilder();
        try (Object object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
            String string3;
            while ((string3 = ((BufferedReader)object).readLine()) != null) {
                ((StringBuilder)object).append(string3);
            }
        }
        object = new JSONObject(((StringBuilder)object).toString());
        long l = ((JSONObject)object).getJSONObject("result").getLong("value");
        BigDecimal bigDecimal = new BigDecimal(l).divide(new BigDecimal(1000000000));
        return bigDecimal;
    }

    public static Map<String, BigDecimal> getSolanaTopTokenBalances(String string) throws Exception {
        Object object;
        Map<String, String> map = Map.of("USDC", "EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v", "USDT", "Es9vMFrzaCERbN9wB1aV1Pq7bEmfQCCX4FEqwr7dz4Nz", "SRM", "9H8arYPP5kDVa9KHXG7kFDqwNqRG9XRbbPnyk3eykbLL", "RAY", "4k3Dyjzvzp8eH1C9JNhErL7r1rN9Ete8VpC6Qq2qdtZm");
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        for (String object22 : map.keySet()) {
            hashMap.put(object22, BigDecimal.ZERO);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("jsonrpc", "2.0");
        jSONObject.put("id", 1);
        jSONObject.put("method", "getTokenAccountsByOwner");
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(string);
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("programId", "TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA");
        jSONArray.put(jSONObject2);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("encoding", "jsonParsed");
        jSONArray.put(jSONObject3);
        jSONObject.put("params", jSONArray);
        URL uRL = new URL(SOLANA_RPC_URL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setDoOutput(true);
        try (Object object2 = httpURLConnection.getOutputStream();){
            ((OutputStream)object2).write(jSONObject.toString().getBytes(StandardCharsets.UTF_8));
            ((OutputStream)object2).flush();
        }
        object2 = new StringBuilder();
        try (Object object3 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));){
            while ((object = ((BufferedReader)object3).readLine()) != null) {
                ((StringBuilder)object2).append((String)object);
            }
        }
        object3 = new JSONObject(((StringBuilder)object2).toString());
        object = ((JSONObject)object3).getJSONObject("result").getJSONArray("value");
        block12: for (int i = 0; i < ((JSONArray)object).length(); ++i) {
            JSONObject jSONObject4 = ((JSONArray)object).getJSONObject(i).getJSONObject("account");
            JSONObject jSONObject5 = jSONObject4.getJSONObject("data").getJSONObject("parsed").getJSONObject("info");
            String string2 = jSONObject5.getString("mint");
            String string3 = jSONObject5.getJSONObject("tokenAmount").getString("uiAmountString");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getValue().equals(string2)) continue;
                hashMap.put(entry.getKey(), new BigDecimal(string3));
                continue block12;
            }
        }
        return hashMap;
    }

    public static BigDecimal getSolanaUSDCBalance(Map<String, BigDecimal> map) {
        return map.getOrDefault("USDC", BigDecimal.ZERO);
    }

    public static BigDecimal getSolanaUSDTBalance(Map<String, BigDecimal> map) {
        return map.getOrDefault("USDT", BigDecimal.ZERO);
    }

    public static BigDecimal getSolanaSRMBalance(Map<String, BigDecimal> map) {
        return map.getOrDefault("SRM", BigDecimal.ZERO);
    }

    public static BigDecimal getSolanaRAYBalance(Map<String, BigDecimal> map) {
        return map.getOrDefault("RAY", BigDecimal.ZERO);
    }
}

