/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class Config {
    public static final String BITQUERY_API_KEY;
    public static final String ETHERSCAN_API_KEY;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> loadEnvFromResource(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try (InputStream inputStream = Config.class.getResourceAsStream(string);){
            if (inputStream == null) {
                System.err.println("Failed to load .env resource: " + string);
                HashMap<String, String> hashMap2 = hashMap;
                return hashMap2;
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).startsWith("#") || !string2.contains("=")) continue;
                    int n = string2.indexOf(61);
                    String string3 = string2.substring(0, n).trim();
                    String string4 = string2.substring(n + 1).trim();
                    hashMap.put(string3, string4);
                }
                return hashMap;
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to load .env resource: " + iOException.getMessage());
        }
        return hashMap;
    }

    private static Map<String, String> loadEnv(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#") || !string2.contains("=")) continue;
                int n = string2.indexOf(61);
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                hashMap.put(string3, string4);
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to load .env file: " + iOException.getMessage());
        }
        return hashMap;
    }

    static {
        Map<String, String> map = Config.loadEnvFromResource("/addressvalidate.env");
        BITQUERY_API_KEY = map.getOrDefault("BITQUERY_API_KEY", "");
        ETHERSCAN_API_KEY = map.getOrDefault("ETHERSCAN_API_KEY", "");
    }
}

