/*
 * Decompiled with CFR 0.152.
 */
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class KeyGenerator {
    private static boolean balanceCheckingEnabled = true;
    private static JTextField inputField;
    private static JLabel statusLabel;
    private static JRadioButton base2Button;
    private static JRadioButton base10Button;
    private static JRadioButton base16Button;
    private static JRadioButton base58Button;
    private static JRadioButton base62Button;
    private static JRadioButton WIFButton;
    private static JTextArea privateKeyBase2Field;
    private static JTextField privateKeyHexField;
    private static JTextField privateKeyWifUncompressedField;
    private static JTextField privateKeyWifCompressedField;
    private static JTextField secp256k1PubXField;
    private static JTextField secp256k1PubYField;
    private static JTextField ed25519PubXField;
    private static JTextField ed25519PubYField;
    private static JTextArea btcUncompressedField;
    private static JTextField btcCompressedField;
    private static JTextField btcP2PKHField;
    private static JTextField btcP2PKHFieldUC;
    private static JTextField btcP2WPKHField;
    private static JTextField btcP2TRField;
    private static JTextField ethAddressField;
    private static JTextField tronAddressField;
    private static JTextArea xrpAddressField;
    private static JTextField solanaAddressField;
    private static JTextField btcP2PKHBalanceField;
    private static JTextField btcP2PKHucBalanceField;
    private static JTextField btcP2WPKHBalanceField;
    private static JTextField btcP2TRBalanceField;
    private static JTextField ethBalanceField;
    private static JTextField tronBalanceField;
    private static JTextField xrpBalanceField;
    private static JTextField solanaBalanceField;
    private static JButton ethTokenButton;
    private static JButton tronTokenButton;
    private static JButton xrpTokenButton;
    private static JButton solTokenButton;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(new FlatLightLaf());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("Key Generator");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(1000, 850);
            jFrame.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jFrame.add((Component)new JScrollPane(jPanel), "Center");
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBorder(BorderFactory.createTitledBorder(KeyGenerator.createTitledFont("Input")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            jPanel2.add((Component)new JLabel("Enter Private Key:"), gridBagConstraints);
            inputField = new JTextField(50);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)inputField, gridBagConstraints);
            JCheckBox jCheckBox = new JCheckBox("Enable Balance Check");
            jCheckBox.setSelected(true);
            jCheckBox.addItemListener(itemEvent -> KeyGenerator.changeBalanceChecking(jCheckBox));
            JButton jButton = new JButton("Generate Keys");
            JButton jButton2 = new JButton("Generate Random Key");
            JButton jButton3 = new JButton("Clear Data");
            jButton.addActionListener(actionEvent -> KeyGenerator.generateKeys());
            jButton2.addActionListener(actionEvent -> KeyGenerator.generateRandomKey());
            jButton3.addActionListener(actionEvent -> KeyGenerator.clearData());
            JPanel jPanel3 = new JPanel(new FlowLayout(2, 10, 0));
            jPanel3.add(jCheckBox);
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            jPanel3.add(jButton3);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            jPanel.add(jPanel2);
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            jPanel4.setBorder(BorderFactory.createTitledBorder(KeyGenerator.createTitledFont("Interpret As Base")));
            ButtonGroup buttonGroup = new ButtonGroup();
            base2Button = new JRadioButton("Base 2");
            base10Button = new JRadioButton("Base 10");
            base16Button = new JRadioButton("Base 16");
            base58Button = new JRadioButton("Base 58");
            base62Button = new JRadioButton("Base 62");
            WIFButton = new JRadioButton("WIF Formatted");
            buttonGroup.add(base2Button);
            buttonGroup.add(base10Button);
            buttonGroup.add(base16Button);
            buttonGroup.add(base58Button);
            buttonGroup.add(base62Button);
            buttonGroup.add(WIFButton);
            jPanel4.add(base2Button);
            jPanel4.add(base10Button);
            jPanel4.add(base16Button);
            jPanel4.add(base58Button);
            jPanel4.add(base62Button);
            jPanel4.add(WIFButton);
            base16Button.setSelected(true);
            jPanel.add(jPanel4);
            JPanel jPanel5 = new JPanel(new GridBagLayout());
            jPanel5.setBorder(BorderFactory.createTitledBorder(KeyGenerator.createTitledFont("Private Key Formats")));
            privateKeyBase2Field = KeyGenerator.createMultilineOutputField("Base 2:", jPanel5, 0);
            privateKeyHexField = KeyGenerator.createOutputField("Base 16:", jPanel5, 1);
            privateKeyWifUncompressedField = KeyGenerator.createOutputField("WIF (Uncompressed):", jPanel5, 2);
            privateKeyWifCompressedField = KeyGenerator.createOutputField("WIF (Compressed):", jPanel5, 3);
            jPanel.add(jPanel5);
            JPanel jPanel6 = new JPanel(new GridBagLayout());
            jPanel6.setBorder(BorderFactory.createTitledBorder(KeyGenerator.createTitledFont("Public Key Coordinates")));
            secp256k1PubXField = KeyGenerator.createOutputField("secp256k1 Public Key X:", jPanel6, 0);
            secp256k1PubYField = KeyGenerator.createOutputField("secp256k1 Public Key Y:", jPanel6, 1);
            ed25519PubXField = KeyGenerator.createOutputField("ED25519 Public Key X:", jPanel6, 2);
            ed25519PubYField = KeyGenerator.createOutputField("ED25519 Public Key Y:", jPanel6, 3);
            jPanel.add(jPanel6);
            JPanel jPanel7 = new JPanel(new GridBagLayout());
            jPanel7.setBorder(BorderFactory.createTitledBorder(KeyGenerator.createTitledFont("Public Key Addresses")));
            int n = 0;
            btcUncompressedField = KeyGenerator.createMultilineOutputField("Bitcoin Uncompressed Public Key:", jPanel7, n++);
            btcCompressedField = KeyGenerator.createOutputField("Bitcoin Compressed Public Key:", jPanel7, n++);
            btcP2PKHField = KeyGenerator.createOutputField("P2PKH Address from Compressed:", jPanel7, n);
            btcP2PKHBalanceField = KeyGenerator.createBalanceField(jPanel7, n++);
            btcP2PKHFieldUC = KeyGenerator.createOutputField("P2PKH Address from Uncompressed:", jPanel7, n);
            btcP2PKHucBalanceField = KeyGenerator.createBalanceField(jPanel7, n++);
            btcP2WPKHField = KeyGenerator.createOutputField("Bitcoin P2WPKH Address:", jPanel7, n);
            btcP2WPKHBalanceField = KeyGenerator.createBalanceField(jPanel7, n++);
            btcP2TRField = KeyGenerator.createOutputField("Bitcoin Basic P2TR Address:", jPanel7, n);
            btcP2TRBalanceField = KeyGenerator.createBalanceField(jPanel7, n++);
            JTextField[] jTextFieldArray = new JTextField[1];
            JTextField[] jTextFieldArray2 = new JTextField[1];
            JButton[] jButtonArray = new JButton[1];
            KeyGenerator.addAddressRowWithTokens(jPanel7, n++, "Ethereum Address:", jTextFieldArray, jTextFieldArray2, jButtonArray, "ethereum");
            ethAddressField = jTextFieldArray[0];
            ethBalanceField = jTextFieldArray2[0];
            ethTokenButton = jButtonArray[0];
            JTextField[] jTextFieldArray3 = new JTextField[1];
            JTextField[] jTextFieldArray4 = new JTextField[1];
            JButton[] jButtonArray2 = new JButton[1];
            KeyGenerator.addAddressRowWithTokens(jPanel7, n++, "TRON Address:", jTextFieldArray3, jTextFieldArray4, jButtonArray2, "tron");
            tronAddressField = jTextFieldArray3[0];
            tronBalanceField = jTextFieldArray4[0];
            tronTokenButton = jButtonArray2[0];
            JTextArea[] jTextAreaArray = new JTextArea[1];
            JTextField[] jTextFieldArray5 = new JTextField[1];
            JButton[] jButtonArray3 = new JButton[1];
            KeyGenerator.addXRPAddressAreaRowWithTokens(jPanel7, n++, "XRP (Ripple) Address:", jTextAreaArray, jTextFieldArray5, jButtonArray3, "xrp");
            xrpAddressField = jTextAreaArray[0];
            xrpBalanceField = jTextFieldArray5[0];
            xrpTokenButton = jButtonArray3[0];
            JTextField[] jTextFieldArray6 = new JTextField[1];
            JTextField[] jTextFieldArray7 = new JTextField[1];
            JButton[] jButtonArray4 = new JButton[1];
            KeyGenerator.addAddressRowWithTokens(jPanel7, n++, "Solana Address:", jTextFieldArray6, jTextFieldArray7, jButtonArray4, "solana");
            solanaAddressField = jTextFieldArray6[0];
            solanaBalanceField = jTextFieldArray7[0];
            solTokenButton = jButtonArray4[0];
            jPanel.add(jPanel7);
            statusLabel = new JLabel(" ");
            statusLabel.setFont(new Font("SansSerif", 2, 12));
            statusLabel.setForeground(Color.DARK_GRAY);
            statusLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jFrame.add((Component)statusLabel, "South");
            jFrame.setVisible(true);
        });
    }

    private static TitledBorder createTitledFont(String string) {
        Font font = UIManager.getFont("TitledBorder.font").deriveFont(1, 14.0f);
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string, 0, 0, font);
    }

    private static JTextField createOutputField(String string, JPanel jPanel, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        JTextField jTextField = new JTextField(40);
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, gridBagConstraints);
        return jTextField;
    }

    private static JTextField createBalanceField(JPanel jPanel, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        JTextField jTextField = new JTextField(10);
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, gridBagConstraints);
        return jTextField;
    }

    private static JTextArea createMultilineOutputField(String string, JPanel jPanel, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        JTextArea jTextArea = new JTextArea(3, 40);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setFont(new JTextField().getFont());
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jTextArea;
    }

    private static void addAddressRowWithTokens(JPanel jPanel, int n, String string, JTextField[] jTextFieldArray, JTextField[] jTextFieldArray2, JButton[] jButtonArray, String string2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        JTextField jTextField = new JTextField(20);
        jTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jTextField, gridBagConstraints);
        jTextFieldArray[0] = jTextField;
        JTextField jTextField2 = new JTextField(12);
        jTextField2.setEditable(false);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)jTextField2, gridBagConstraints);
        jTextFieldArray2[0] = jTextField2;
        JButton jButton = new JButton("Check Tokens");
        jButton.addActionListener(actionEvent -> {
            String string2 = jTextField.getText();
            if (string2 == null || string2.isEmpty()) {
                return;
            }
            Frame frame = (Frame)SwingUtilities.getWindowAncestor(jButton);
            KeyGenerator.openTokenPopup(frame, string2, string2);
        });
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)jButton, gridBagConstraints);
        jButtonArray[0] = jButton;
    }

    private static void addXRPAddressAreaRowWithTokens(JPanel jPanel, int n, String string, JTextArea[] jTextAreaArray, JTextField[] jTextFieldArray, JButton[] jButtonArray, String string2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        JTextArea jTextArea = new JTextArea(3, 20);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jTextAreaArray[0] = jTextArea;
        JTextField jTextField = new JTextField(12);
        jTextField.setEditable(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jTextField, gridBagConstraints);
        jTextFieldArray[0] = jTextField;
        JButton jButton = new JButton("Check Tokens");
        jButton.addActionListener(actionEvent -> {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2;
            String string2 = jTextArea.getText();
            if (string2 == null || string2.isBlank()) {
                return;
            }
            String[] stringArray = string2.split("\\R");
            Frame frame = (Frame)SwingUtilities.getWindowAncestor(jButton);
            try {
                bigDecimal2 = BalanceChecker.getXRPBalance(stringArray[0]);
            }
            catch (Exception exception) {
                bigDecimal2 = BigDecimal.ZERO;
            }
            try {
                bigDecimal = BalanceChecker.getXRPBalance(stringArray[2]);
            }
            catch (Exception exception) {
                bigDecimal = BigDecimal.ZERO;
            }
            if (bigDecimal2.compareTo(BigDecimal.ZERO) > 0) {
                var9_10 = stringArray[0].trim();
                if (!var9_10.isEmpty()) {
                    KeyGenerator.openTokenPopup(frame, var9_10, string2);
                }
            } else if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                var9_10 = stringArray[2].trim();
                if (!var9_10.isEmpty()) {
                    KeyGenerator.openTokenPopup(frame, var9_10, string2);
                }
            } else {
                var9_10 = stringArray[0].trim();
                if (!var9_10.isEmpty()) {
                    KeyGenerator.openTokenPopup(frame, var9_10, string2);
                }
            }
        });
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        jButtonArray[0] = jButton;
    }

    private static void clearData() {
        inputField.setText("");
        KeyGenerator.clearDataLeaveText();
    }

    private static void changeBalanceChecking(JCheckBox jCheckBox) {
        balanceCheckingEnabled = jCheckBox.isSelected();
        ethTokenButton.setEnabled(balanceCheckingEnabled);
        tronTokenButton.setEnabled(balanceCheckingEnabled);
        xrpTokenButton.setEnabled(balanceCheckingEnabled);
        solTokenButton.setEnabled(balanceCheckingEnabled);
    }

    private static void clearDataLeaveText() {
        privateKeyBase2Field.setText("");
        privateKeyHexField.setText("");
        privateKeyWifUncompressedField.setText("");
        privateKeyWifCompressedField.setText("");
        secp256k1PubXField.setText("");
        secp256k1PubYField.setText("");
        ed25519PubXField.setText("");
        ed25519PubYField.setText("");
        btcUncompressedField.setText("");
        btcCompressedField.setText("");
        btcP2PKHField.setText("");
        btcP2PKHFieldUC.setText("");
        btcP2WPKHField.setText("");
        btcP2TRField.setText("");
        ethAddressField.setText("");
        tronAddressField.setText("");
        xrpAddressField.setText("");
        solanaAddressField.setText("");
        btcP2PKHBalanceField.setText("");
        btcP2PKHucBalanceField.setText("");
        btcP2WPKHBalanceField.setText("");
        btcP2TRBalanceField.setText("");
        ethBalanceField.setText("");
        tronBalanceField.setText("");
        xrpBalanceField.setText("");
        solanaBalanceField.setText("");
        statusLabel.setText("");
    }

    private static void generateKeys() {
        BigDecimal bigDecimal;
        Object object;
        Object object2;
        byte[] byArray;
        statusLabel.setText("");
        String string = inputField.getText().replaceAll("\\s+", "");
        if (string.isEmpty()) {
            KeyGenerator.clearData();
            statusLabel.setText("Please enter a string to analyze.");
            return;
        }
        int n = 0;
        if (base2Button.isSelected()) {
            n = 2;
        } else if (base10Button.isSelected()) {
            n = 10;
        } else if (base16Button.isSelected()) {
            n = 16;
        } else if (base58Button.isSelected()) {
            n = 58;
        } else if (base62Button.isSelected()) {
            n = 62;
        } else if (WIFButton.isSelected()) {
            n = -1;
        } else {
            statusLabel.setText("Must select a base to interpret.");
            return;
        }
        KeyGenerator.clearDataLeaveText();
        inputField.setText(string);
        try {
            byArray = PrivateKeyFunctions.getPKBytesFromString(string, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            statusLabel.setText("Illegal Argument: " + illegalArgumentException.getMessage());
            return;
        }
        privateKeyBase2Field.setText("0b" + PrivateKeyFunctions.getStringFromBytes(byArray, 2));
        privateKeyHexField.setText("0x" + PrivateKeyFunctions.getStringFromBytes(byArray, 16));
        byte[] byArray2 = PrivateKeyFunctions.PrivateKeytoWIF(byArray, true);
        byte[] byArray3 = PrivateKeyFunctions.PrivateKeytoWIF(byArray, false);
        if (byArray2.equals(byArray3) && byArray2.equals(byArray)) {
            statusLabel.setText("Error calculating WIF Private Key");
            return;
        }
        privateKeyWifUncompressedField.setText(PrivateKeyFunctions.getStringFromBytes(byArray3, 58));
        privateKeyWifCompressedField.setText(PrivateKeyFunctions.getStringFromBytes(byArray2, 58));
        secp256k1PubXField.setText("0x" + PrivateKeyFunctions.getStringFromBytes(PrivateKeyFunctions.getBitcoinPubKeyX(byArray), 16));
        secp256k1PubYField.setText("0x" + PrivateKeyFunctions.getStringFromBytes(PrivateKeyFunctions.getBitcoinPubKeyY(byArray), 16));
        btcUncompressedField.setText(PrivateKeyFunctions.getBitcoinUncompressedPubKeyString(byArray));
        btcCompressedField.setText(PrivateKeyFunctions.getBitCoinCompressedPubKeyString(byArray));
        byte[] byArray4 = PrivateKeyFunctions.getBitcoinP2PKH(byArray, true);
        byte[] byArray5 = PrivateKeyFunctions.getBitcoinP2PKH(byArray, false);
        btcP2PKHField.setText(PrivateKeyFunctions.getStringFromBytes(byArray4, 58));
        if (balanceCheckingEnabled) {
            try {
                object2 = btcP2PKHField.getText();
                object = BalanceChecker.getBTCBalance((String)object2);
                bigDecimal = object.setScale(8);
                btcP2PKHBalanceField.setText(bigDecimal.toPlainString() + " BTC");
            }
            catch (Exception exception) {
                btcP2PKHBalanceField.setText("Retrieval Error");
            }
        }
        btcP2PKHFieldUC.setText(PrivateKeyFunctions.getStringFromBytes(byArray5, 58));
        if (balanceCheckingEnabled) {
            try {
                object2 = btcP2PKHFieldUC.getText();
                object = BalanceChecker.getBTCBalance((String)object2);
                bigDecimal = object.setScale(8);
                btcP2PKHucBalanceField.setText(bigDecimal.toPlainString() + " BTC");
            }
            catch (Exception exception) {
                btcP2PKHucBalanceField.setText("Retrieval Error");
            }
        }
        btcP2WPKHField.setText(PrivateKeyFunctions.getBitcoinP2WPKHString(byArray));
        if (balanceCheckingEnabled) {
            try {
                object2 = btcP2WPKHField.getText();
                object = BalanceChecker.getBTCBalance((String)object2);
                bigDecimal = object.setScale(8);
                btcP2WPKHBalanceField.setText(bigDecimal.toPlainString() + " BTC");
            }
            catch (Exception exception) {
                btcP2WPKHBalanceField.setText("Retrieval Error");
            }
        }
        btcP2TRField.setText(PrivateKeyFunctions.getBitcoinP2TRString(byArray));
        if (balanceCheckingEnabled) {
            try {
                object2 = btcP2TRField.getText();
                object = BalanceChecker.getBTCBalance((String)object2);
                bigDecimal = object.setScale(8);
                btcP2TRBalanceField.setText(bigDecimal.toPlainString() + " BTC");
            }
            catch (Exception exception) {
                btcP2TRBalanceField.setText("Retrieval Error");
            }
        }
        ethAddressField.setText(PrivateKeyFunctions.getEthereumPKString(byArray));
        if (balanceCheckingEnabled) {
            try {
                object2 = ethAddressField.getText();
                object = BalanceChecker.getETHBalance((String)object2);
                bigDecimal = object.setScale(8);
                ethBalanceField.setText(bigDecimal.toPlainString() + " ETH");
                ethBalanceField.setCaretPosition(0);
            }
            catch (Exception exception) {
                ethBalanceField.setText("Retrieval Error");
            }
        }
        tronAddressField.setText(PrivateKeyFunctions.getTronAddressString(byArray));
        if (balanceCheckingEnabled) {
            try {
                object2 = tronAddressField.getText();
                object = BalanceChecker.getTronBalance((String)object2);
                bigDecimal = object.setScale(8);
                tronBalanceField.setText(bigDecimal.toPlainString() + " TRX");
                tronBalanceField.setCaretPosition(0);
            }
            catch (Exception exception) {
                tronBalanceField.setText("Retrieval Error");
            }
        }
        xrpAddressField.setText(PrivateKeyFunctions.getXRPED25519AddressString(byArray));
        xrpAddressField.append("\nor\n");
        xrpAddressField.append(PrivateKeyFunctions.getXRPsecp256k1AddressString(byArray));
        if (balanceCheckingEnabled) {
            try {
                object2 = xrpAddressField.getText();
                object = ((String)object2).split("\\R");
                bigDecimal = BalanceChecker.getXRPBalance(object[0]);
                BigDecimal bigDecimal2 = BalanceChecker.getXRPBalance(object[2]);
                BigDecimal bigDecimal3 = bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal.setScale(8) : (bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2.setScale(8) : BigDecimal.ZERO);
                xrpBalanceField.setText(bigDecimal3.toPlainString() + " XRP");
                xrpBalanceField.setCaretPosition(0);
            }
            catch (Exception exception) {
                xrpBalanceField.setText("Retrieval Error");
            }
        }
        solanaAddressField.setText(PrivateKeyFunctions.getSolanaAddressString(byArray));
        if (balanceCheckingEnabled) {
            try {
                object2 = solanaAddressField.getText();
                object = BalanceChecker.getSOLBalance((String)object2);
                bigDecimal = object.setScale(8);
                solanaBalanceField.setText(bigDecimal.toPlainString() + " SOL");
                solanaBalanceField.setCaretPosition(0);
            }
            catch (Exception exception) {
                solanaBalanceField.setText("Retrieval Error");
            }
        }
        object2 = PrivateKeyFunctions.getED25519PubKeyY(byArray);
        ed25519PubYField.setText("0x" + PrivateKeyFunctions.getStringFromBytes((byte[])object2, 16));
        try {
            object = PrivateKeyFunctions.getED25519PubKeyX(byArray);
            ed25519PubXField.setText("0x" + PrivateKeyFunctions.getStringFromBytes((byte[])object, 16));
        }
        catch (Exception exception) {
            ed25519PubXField.setText("Error calculating X value. May not exist on the Edwards curve.");
        }
    }

    private static void generateRandomKey() {
        statusLabel.setText("");
        KeyGenerator.clearDataLeaveText();
        byte[] byArray = new byte[32];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        inputField.setText(HexFormat.of().formatHex(byArray));
        base16Button.setSelected(true);
        KeyGenerator.generateKeys();
    }

    private static void openTokenPopup(Frame frame, String string, String string2) {
        Map<String, String> map;
        switch (string2.toLowerCase()) {
            case "ethereum": {
                try {
                    Map<String, BigDecimal> map2 = BalanceChecker.getAllERC20TokenBalances(string);
                    map = new HashMap<String, String>();
                    for (Map.Entry<String, BigDecimal> entry : map2.entrySet()) {
                        map.put(entry.getKey(), entry.getValue().toPlainString());
                    }
                    break;
                }
                catch (Exception exception) {
                    map = Map.of("Lookup Error", "No token data available");
                    break;
                }
            }
            case "tron": {
                try {
                    Map<String, BigDecimal> map3 = BalanceChecker.getAllTRC20TokenBalances(string);
                    map = new HashMap<String, String>();
                    for (Map.Entry<String, BigDecimal> entry : map3.entrySet()) {
                        map.put(entry.getKey(), entry.getValue().toPlainString());
                    }
                    break;
                }
                catch (Exception exception) {
                    map = Map.of("Lookup Error", "No token data available");
                    break;
                }
            }
            case "xrp": {
                try {
                    Map<String, BigDecimal> map4 = BalanceChecker.getAllXRPTokens(string);
                    map = new HashMap<String, String>();
                    for (Map.Entry<String, BigDecimal> entry : map4.entrySet()) {
                        map.put(entry.getKey(), entry.getValue().toPlainString());
                    }
                    break;
                }
                catch (Exception exception) {
                    map = Map.of("Lookup Error", "No token data available");
                    break;
                }
            }
            case "solana": {
                try {
                    Map<String, BigDecimal> map5 = BalanceChecker.getSolanaTopTokenBalances(string);
                    map = new HashMap<String, String>();
                    for (Map.Entry<String, BigDecimal> entry : map5.entrySet()) {
                        map.put(entry.getKey(), entry.getValue().toPlainString());
                    }
                    break;
                }
                catch (Exception exception) {
                    map = Map.of("Lookup Error", "No token data available");
                    break;
                }
            }
            default: {
                map = Map.of("Unknown Network", "No token data available");
            }
        }
        Object object = KeyGenerator.createTokenPopupDialog(frame, string, string2, map);
        ((Dialog)object).setVisible(true);
    }

    /*
     * Exception decompiling
     */
    private static JDialog createTokenPopupDialog(Frame var0, String var1_1, String var2_2, Map<String, String> var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$createTokenPopupDialog$9(JDialog jDialog, ActionEvent actionEvent) {
        jDialog.dispose();
    }

    private static /* synthetic */ String[][] lambda$createTokenPopupDialog$8(int n) {
        return new String[n][];
    }
}

