/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;

public class PrivateKeyFunctions {
    private static final String BASE58_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final String XRP_BASE_58_ALPHABET = "rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz";
    private static final String BASE62_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String BECH32_ALPHABET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";

    private static BigInteger decodeBaseX(String string, String string2) {
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.valueOf(string2.length());
        for (char c : string.toCharArray()) {
            int n = string2.indexOf(c);
            if (n == -1) {
                throw new IllegalArgumentException("Invalid character in base-encoded string: " + c);
            }
            bigInteger = bigInteger.multiply(bigInteger2).add(BigInteger.valueOf(n));
        }
        return bigInteger;
    }

    private static String encodeBaseX(BigInteger bigInteger, String string) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            return String.valueOf(string.charAt(0));
        }
        StringBuilder stringBuilder = new StringBuilder();
        BigInteger bigInteger2 = BigInteger.valueOf(string.length());
        while (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
            stringBuilder.insert(0, string.charAt(bigIntegerArray[1].intValue()));
            bigInteger = bigIntegerArray[0];
        }
        return stringBuilder.toString();
    }

    public static String encodeBaseX(byte[] byArray, String string) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        int n = 0;
        for (byte by : byArray) {
            if (by != 0) break;
            ++n;
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        String string2 = PrivateKeyFunctions.encodeBaseX(bigInteger, string);
        int n2 = string.charAt(0);
        return String.valueOf((char)n2).repeat(n) + string2;
    }

    public static byte[] getPKBytesFromString(String string, int n) {
        try {
            Object object;
            BigInteger bigInteger;
            switch (n) {
                case 2: {
                    if (string.length() >= 2 && string.substring(0, 2).equals("0b")) {
                        string = string.substring(2);
                    }
                    try {
                        bigInteger = new BigInteger(string, 2);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("String Contains Illegal Characters for Base 2");
                    }
                }
                case 10: {
                    if (string.length() >= 2 && string.substring(0, 2).equals("0d")) {
                        string = string.substring(2);
                    }
                    try {
                        bigInteger = new BigInteger(string, 10);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("String Contains Illegal Characters for Base 10");
                    }
                }
                case 16: {
                    if (string.length() >= 2 && string.substring(0, 2).equals("0x")) {
                        string = string.substring(2);
                    }
                    try {
                        bigInteger = new BigInteger(string, 16);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("String Contains Illegal Characters for Base 16");
                    }
                }
                case 58: {
                    bigInteger = PrivateKeyFunctions.decodeBaseX(string, BASE58_ALPHABET);
                    break;
                }
                case 62: {
                    bigInteger = PrivateKeyFunctions.decodeBaseX(string, BASE62_ALPHABET);
                    break;
                }
                case -1: {
                    if (string.length() != 51 && string.length() != 52) {
                        throw new IllegalArgumentException("WIF selected but key has wrong number of characters.");
                    }
                    if (string.length() == 52 && string.charAt(0) != 'K' && string.charAt(0) != 'L') {
                        throw new IllegalArgumentException("WIF selected but key has wrong first character.");
                    }
                    if (string.length() == 51 && string.charAt(0) != '5') {
                        throw new IllegalArgumentException("WIF selected but key has wrong first character.");
                    }
                    try {
                        object = PrivateKeyFunctions.decodeBaseX(string, BASE58_ALPHABET);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("WIF selected but key has invalid characters for Base 58.");
                    }
                    object = PrivateKeyFunctions.decodeWIFtoByteArray(string);
                    bigInteger = new BigInteger((byte[])object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported base: " + n);
                }
            }
            if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
                throw new IllegalArgumentException("Must not be 0.");
            }
            object = bigInteger.toByteArray();
            if (((byte[])object).length > 32 && object[0] == 0) {
                object = Arrays.copyOfRange(object, 1, ((byte[])object).length);
            }
            if (((byte[])object).length > 32) {
                throw new IllegalArgumentException("Decoded key is longer than 32 bytes (256 bits): invalid private key.");
            }
            if (((byte[])object).length < 32) {
                byte[] byArray = new byte[32];
                System.arraycopy(object, 0, byArray, 32 - ((byte[])object).length, ((byte[])object).length);
                return byArray;
            }
            return object;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to parse private key: " + exception.getMessage());
        }
    }

    private static byte[] decodeWIFtoByteArray(String string) throws IllegalArgumentException {
        Object object;
        BigInteger bigInteger = new BigInteger("0", 10);
        bigInteger = PrivateKeyFunctions.decodeBaseX(string, BASE58_ALPHABET);
        String string2 = "";
        string2 = bigInteger.toString(16);
        byte[] byArray = PrivateKeyFunctions.hexStringToByteArray(string2);
        if (byArray[0] != -128) {
            throw new IllegalArgumentException("Version byte incorrect for WIF.");
        }
        if (byArray.length < 37) {
            throw new IllegalArgumentException("Encoded private key too short for WIF.");
        }
        if (byArray.length > 38) {
            if (byArray.length == 38) {
                if (byArray[32] != 1) {
                    throw new IllegalArgumentException("Invalid Compression byte for WIF.");
                }
            } else {
                throw new IllegalArgumentException("Encoded private key too long for WIF.");
            }
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[32];
        System.arraycopy(byArray, 1, byArray4, 0, 32);
        System.arraycopy(byArray, byArray.length - 4, byArray3, 0, 4);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length - 4);
        try {
            object = MessageDigest.getInstance("SHA-256");
            byte[] byArray5 = ((MessageDigest)object).digest(byArray2);
            byte[] byArray6 = ((MessageDigest)object).digest(byArray5);
            byte[] byArray7 = new byte[4];
            System.arraycopy(byArray6, 0, byArray7, 0, 4);
            boolean bl = Arrays.equals(byArray3, byArray7);
            if (!bl) {
                throw new IllegalArgumentException("Checksum fail for WIF format.");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("No SHA 256 Algorithm to Decode WIF.");
        }
        object = new byte[32];
        System.arraycopy(byArray2, 1, object, 0, 32);
        return object;
    }

    public static byte[] hexStringToByteArray(String object) {
        if (((String)object).length() == 0) {
            return new byte[0];
        }
        if (((String)object).length() % 2 != 0) {
            object = "0" + (String)object;
        }
        int n = ((String)object).length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            int n2 = Character.digit(((String)object).charAt(i), 16);
            int n3 = Character.digit(((String)object).charAt(i + 1), 16);
            byArray[i / 2] = (byte)((n2 << 4) + n3);
        }
        return byArray;
    }

    public static String getStringFromBytes(byte[] byArray, int n) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (n) {
            case 2: {
                stringBuilder = new StringBuilder();
                for (byte by : byArray) {
                    stringBuilder.append(String.format("%8s", Integer.toBinaryString(by & 0xFF)).replace(' ', '0'));
                }
                return stringBuilder.toString();
            }
            case 10: {
                return new BigInteger(1, byArray).toString(10);
            }
            case 16: {
                for (byte by : byArray) {
                    stringBuilder.append(String.format("%02x", by));
                }
                return stringBuilder.toString();
            }
            case 58: {
                return PrivateKeyFunctions.encodeBaseX(byArray, BASE58_ALPHABET);
            }
            case 62: {
                return PrivateKeyFunctions.encodeBaseX(byArray, BASE62_ALPHABET);
            }
        }
        throw new IllegalArgumentException("Unsupported base: " + n);
    }

    public static byte[] PrivateKeytoWIF(byte[] byArray, boolean bl) {
        int n = -128;
        byte by = 1;
        byte[] byArray2 = new byte[4];
        if (byArray.length != 32) {
            return byArray;
        }
        if (!bl) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                byte[] byArray3 = new byte[byArray.length + 1];
                byte[] byArray4 = new byte[byArray.length + 5];
                byArray3[0] = n;
                System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
                byte[] byArray5 = messageDigest.digest(byArray3);
                byte[] byArray6 = messageDigest.digest(byArray5);
                System.arraycopy(byArray6, 0, byArray2, 0, 4);
                byArray4[0] = n;
                System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
                System.arraycopy(byArray2, 0, byArray4, byArray4.length - 4, 4);
                return byArray4;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return byArray;
            }
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray7 = new byte[byArray.length + 2];
            byte[] byArray8 = new byte[byArray.length + 6];
            byArray7[0] = n;
            System.arraycopy(byArray, 0, byArray7, 1, byArray.length);
            byArray7[byArray.length + 1] = by;
            byte[] byArray9 = messageDigest.digest(byArray7);
            byte[] byArray10 = messageDigest.digest(byArray9);
            System.arraycopy(byArray10, 0, byArray2, 0, 4);
            byArray8[0] = n;
            System.arraycopy(byArray, 0, byArray8, 1, byArray.length);
            byArray8[byArray.length + 1] = by;
            System.arraycopy(byArray2, 0, byArray8, byArray8.length - 4, 4);
            return byArray8;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return byArray;
        }
    }

    public static byte[] getBitcoinPubKeyX(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Private key must be 32 bytes (256 bits)");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 16);
        if (bigInteger.compareTo(bigInteger2) > 0 || bigInteger.compareTo(bigInteger2) == 0) {
            throw new IllegalArgumentException("Private key too large for curve order");
        }
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec("secp256k1");
        ECPoint eCPoint = eCNamedCurveParameterSpec.getG().multiply(bigInteger).normalize();
        byte[] byArray2 = eCPoint.getAffineXCoord().toBigInteger().toByteArray();
        byte[] byArray3 = new byte[32];
        int n = Math.max(0, byArray2.length - 32);
        int n2 = Math.min(32, byArray2.length);
        System.arraycopy(byArray2, n, byArray3, 32 - n2, n2);
        return byArray3;
    }

    public static byte[] getBitcoinPubKeyY(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Private key must be 32 bytes (256 bits)");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 16);
        if (bigInteger.compareTo(bigInteger2) > 0 || bigInteger.compareTo(bigInteger2) == 0) {
            throw new IllegalArgumentException("Private key too large for curve order");
        }
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec("secp256k1");
        ECPoint eCPoint = eCNamedCurveParameterSpec.getG().multiply(bigInteger).normalize();
        byte[] byArray2 = eCPoint.getAffineYCoord().toBigInteger().toByteArray();
        byte[] byArray3 = new byte[32];
        int n = Math.max(0, byArray2.length - 32);
        int n2 = Math.min(32, byArray2.length);
        System.arraycopy(byArray2, n, byArray3, 32 - n2, n2);
        return byArray3;
    }

    public static String getBitcoinUncompressedPubKeyString(byte[] byArray) {
        String string = "04";
        String string2 = PrivateKeyFunctions.getStringFromBytes(PrivateKeyFunctions.getBitcoinPubKeyX(byArray), 16);
        String string3 = PrivateKeyFunctions.getStringFromBytes(PrivateKeyFunctions.getBitcoinPubKeyY(byArray), 16);
        return string + string2 + string3;
    }

    public static String getBitCoinCompressedPubKeyString(byte[] byArray) {
        BigInteger bigInteger;
        String string = PrivateKeyFunctions.getStringFromBytes(PrivateKeyFunctions.getBitcoinPubKeyX(byArray), 16);
        BigInteger bigInteger2 = new BigInteger(1, PrivateKeyFunctions.getBitcoinPubKeyY(byArray));
        if (bigInteger2.mod(bigInteger = new BigInteger("2")).equals(BigInteger.ZERO)) {
            return "02" + string;
        }
        return "03" + string;
    }

    public static byte[] getBitcoinUncompressedPubKey(byte[] byArray) {
        int n = 4;
        byte[] byArray2 = PrivateKeyFunctions.getBitcoinPubKeyX(byArray);
        byte[] byArray3 = PrivateKeyFunctions.getBitcoinPubKeyY(byArray);
        byte[] byArray4 = new byte[byArray2.length + byArray3.length + 1];
        byArray4[0] = n;
        System.arraycopy(byArray2, 0, byArray4, 1, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length + 1, byArray3.length);
        return byArray4;
    }

    public static byte[] getBitcoinCompressedPubKey(byte[] byArray) {
        BigInteger bigInteger;
        int n = 2;
        int n2 = 3;
        byte[] byArray2 = PrivateKeyFunctions.getBitcoinPubKeyX(byArray);
        byte[] byArray3 = new byte[byArray2.length + 1];
        BigInteger bigInteger2 = new BigInteger(1, PrivateKeyFunctions.getBitcoinPubKeyY(byArray));
        byArray3[0] = bigInteger2.mod(bigInteger = new BigInteger("2")).equals(BigInteger.ZERO) ? n : n2;
        System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
        return byArray3;
    }

    private static byte[] gethash160(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            RIPEMD160Digest rIPEMD160Digest = new RIPEMD160Digest();
            rIPEMD160Digest.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[rIPEMD160Digest.getDigestSize()];
            rIPEMD160Digest.doFinal(byArray3, 0);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static byte[] getBitcoinP2PKH(byte[] byArray, boolean bl) {
        byte by = 0;
        byte[] byArray2 = new byte[25];
        byte[] byArray3 = PrivateKeyFunctions.getBitcoinPubKeyX(byArray);
        byte[] byArray4 = bl ? PrivateKeyFunctions.getBitcoinCompressedPubKey(byArray) : PrivateKeyFunctions.getBitcoinUncompressedPubKey(byArray);
        byte[] byArray5 = PrivateKeyFunctions.gethash160(byArray4);
        byte[] byArray6 = new byte[byArray5.length + 1];
        byArray6[0] = by;
        System.arraycopy(byArray5, 0, byArray6, 1, byArray5.length);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray7 = messageDigest.digest(byArray6);
            byte[] byArray8 = messageDigest.digest(byArray7);
            byArray2[0] = by;
            System.arraycopy(byArray5, 0, byArray2, 1, byArray5.length);
            for (int i = 0; i < 4; ++i) {
                byArray2[21 + i] = byArray8[i];
            }
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static byte[] getP2WPKHdata(byte[] byArray) {
        int n;
        int n2;
        byte[] byArray2 = new byte[22];
        int n3 = 0;
        int n4 = 20;
        byte[] byArray3 = PrivateKeyFunctions.getBitcoinCompressedPubKey(byArray);
        byte[] byArray4 = PrivateKeyFunctions.gethash160(byArray3);
        if (byArray4.length != 20) {
            return null;
        }
        byArray2[0] = n3;
        byArray2[1] = n4;
        System.arraycopy(byArray4, 0, byArray2, 2, byArray4.length);
        int[] nArray = PrivateKeyFunctions.seperateHRPintoFiveBitArray("bc");
        int n5 = 0;
        int n6 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (byte by : byArray4) {
            n2 = by & 0xFF;
            n5 = n5 << 8 | n2;
            n6 += 8;
            while (n6 > 5) {
                byteArrayOutputStream.write(n5 >> n6 - 5 & 0x1F);
                n6 -= 5;
            }
        }
        if (n6 != 0) {
            byteArrayOutputStream.write(n5 << 5 - n6 & 0x1F);
        }
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        int[] nArray2 = new int[nArray.length + byArray5.length + 7];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = n3;
        for (n = 0; n < byArray5.length; ++n) {
            nArray2[nArray.length + 1 + n] = byArray5[n] & 0xFF;
        }
        for (n = 0; n < 6; ++n) {
            nArray2[byArray5.length + nArray.length + 1 + n] = 0;
        }
        int[] nArray3 = new int[6];
        nArray3 = PrivateKeyFunctions.getBech32ChecksumArray(nArray2, 0);
        byte[] byArray6 = new byte[1 + byArray5.length + 6];
        byArray6[0] = n3;
        System.arraycopy(byArray5, 0, byArray6, 1, byArray5.length);
        for (n2 = 0; n2 < 6; ++n2) {
            byArray6[byArray5.length + 1 + n2] = (byte)(nArray3[n2] & 0xFF);
        }
        return byArray6;
    }

    private static int[] seperateHRPintoFiveBitArray(String string) {
        int n;
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            nArray[i] = string.charAt(i);
        }
        int[] nArray2 = new int[string.length() * 2 + 1];
        for (n = 0; n < string.length(); ++n) {
            nArray2[n] = (0xE0 & nArray[n]) >> 5;
        }
        nArray2[string.length()] = 0;
        for (n = 0; n < string.length(); ++n) {
            nArray2[string.length() + 1 + n] = 0x1F & nArray[n];
        }
        return nArray2;
    }

    private static byte[] getP2TRdata(byte[] byArray) {
        int n;
        int n2;
        byte[] byArray2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n3 = 1;
        BigInteger bigInteger = new BigInteger(1, byArray);
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec("secp256k1");
        ECPoint eCPoint = eCNamedCurveParameterSpec.getG().multiply(bigInteger).normalize();
        if (eCPoint.getAffineYCoord().toBigInteger().testBit(0)) {
            bigInteger = eCNamedCurveParameterSpec.getN().subtract(bigInteger);
            eCPoint = eCNamedCurveParameterSpec.getG().multiply(bigInteger).normalize();
        }
        byte[] byArray3 = PrivateKeyFunctions.bigIntTo32Bytes(eCPoint.getAffineXCoord().toBigInteger());
        byte[] byArray4 = "TapTweak".getBytes(StandardCharsets.US_ASCII);
        byte[] byArray5 = PrivateKeyFunctions.bigIntTo32Bytes(eCPoint.getAffineXCoord().toBigInteger());
        byte[] byArray6 = new byte[]{};
        try {
            object4 = MessageDigest.getInstance("SHA-256");
            object3 = ((MessageDigest)object4).digest(byArray4);
            object2 = new byte[((byte[])object3).length * 2 + byArray5.length];
            System.arraycopy(object3, 0, object2, 0, ((byte[])object3).length);
            System.arraycopy(object3, 0, object2, ((byte[])object3).length, ((byte[])object3).length);
            System.arraycopy(byArray5, 0, object2, ((byte[])object3).length * 2, byArray5.length);
            object = MessageDigest.getInstance("SHA-256");
            byArray2 = ((MessageDigest)object).digest((byte[])object2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        object4 = byArray2;
        object3 = new BigInteger(1, (byte[])object4).mod(eCNamedCurveParameterSpec.getN());
        object2 = eCPoint.add(eCNamedCurveParameterSpec.getG().multiply((BigInteger)object3)).normalize();
        object = ((ECPoint)object2).getAffineXCoord().toBigInteger();
        byte[] byArray7 = PrivateKeyFunctions.bigIntTo32Bytes((BigInteger)object);
        int[] nArray = PrivateKeyFunctions.seperateHRPintoFiveBitArray("bc");
        int n4 = 0;
        int n5 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (byte by : byArray7) {
            n2 = by & 0xFF;
            n4 = n4 << 8 | n2;
            n5 += 8;
            while (n5 > 5) {
                byteArrayOutputStream.write(n4 >> n5 - 5 & 0x1F);
                n5 -= 5;
            }
        }
        if (n5 != 0) {
            byteArrayOutputStream.write(n4 << 5 - n5 & 0x1F);
        }
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        int[] nArray2 = new int[byArray8.length + nArray.length + 7];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = n3;
        for (n = nArray.length + 1; n < nArray.length + 1 + byArray8.length; ++n) {
            nArray2[n] = byArray8[n - nArray.length - 1] & 0xFF;
        }
        for (n = 0; n < 6; ++n) {
            nArray2[byArray8.length + nArray.length + 1 + n] = 0;
        }
        int[] nArray3 = new int[6];
        nArray3 = PrivateKeyFunctions.getBech32ChecksumArray(nArray2, 1);
        byte[] byArray9 = new byte[byArray8.length + 7];
        byArray9[0] = n3;
        System.arraycopy(byArray8, 0, byArray9, 1, byArray8.length);
        for (n2 = 0; n2 < 6; ++n2) {
            byArray9[byArray8.length + 1 + n2] = (byte)(nArray3[n2] & 0xFF);
        }
        return byArray9;
    }

    private static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x ", by & 0xFF));
        }
        return stringBuilder.toString();
    }

    private static byte[] bigIntTo32Bytes(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 33 && byArray[0] == 0) {
            byArray = Arrays.copyOfRange(byArray, 1, 33);
        }
        if (byArray.length > 32) {
            throw new IllegalArgumentException("BigInteger X Coordinate too large");
        }
        byte[] byArray2 = new byte[32];
        System.arraycopy(byArray, 0, byArray2, 32 - byArray.length, byArray.length);
        return byArray2;
    }

    private static int[] getBech32ChecksumArray(int[] nArray, int n) {
        int n2 = 1;
        int n3 = 996825010;
        int n4 = 642813549;
        int n5 = 513874426;
        int n6 = 1027748829;
        int n7 = 705979059;
        for (int i = 0; i < nArray.length; ++i) {
            int n8 = n2 >>> 25 & 0x1F;
            int n9 = n2 & 0x1FFFFFF;
            int n10 = n9 << 5;
            int n11 = n10 ^ nArray[i] & 0x1F;
            int n12 = n8 & 1;
            if (n12 != 0) {
                n11 ^= n3;
            }
            if ((n12 = n8 & 2) != 0) {
                n11 ^= n4;
            }
            if ((n12 = n8 & 4) != 0) {
                n11 ^= n5;
            }
            if ((n12 = n8 & 8) != 0) {
                n11 ^= n6;
            }
            if ((n12 = n8 & 0x10) != 0) {
                n11 ^= n7;
            }
            n2 = n11;
        }
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            n2 ^= 1;
        }
        if (n > 0) {
            n2 ^= 0x2BC830A3;
        }
        int[] nArray2 = new int[]{(n2 & 0x3E000000) >> 25, (n2 & 0x1F00000) >> 20, (n2 & 0xF8000) >> 15, (n2 & 0x7C00) >> 10, (n2 & 0x3E0) >> 5, n2 & 0x1F};
        return nArray2;
    }

    public static String getBitcoinP2WPKHString(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getP2WPKHdata(byArray);
        Object object = "";
        object = (String)object + "bc1";
        for (int i = 0; i < byArray2.length; ++i) {
            if ((byArray2[i] & 0xFF) > 31) {
                return "Data Parsing Error";
            }
            object = (String)object + BECH32_ALPHABET.charAt(byArray2[i] & 0xFF);
        }
        return object;
    }

    public static String getBitcoinP2TRString(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getP2TRdata(byArray);
        Object object = "";
        object = (String)object + "bc1";
        for (int i = 0; i < byArray2.length; ++i) {
            if ((byArray2[i] & 0xFF) > 31) {
                return "Data Parsing Error";
            }
            object = (String)object + BECH32_ALPHABET.charAt(byArray2[i] & 0xFF);
        }
        return object;
    }

    public static String getEthereumPKString(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getBitcoinUncompressedPubKey(byArray);
        byte[] byArray3 = new byte[64];
        System.arraycopy(byArray2, 1, byArray3, 0, 64);
        Keccak.Digest256 digest256 = new Keccak.Digest256();
        byte[] byArray4 = digest256.digest(byArray3);
        byte[] byArray5 = new byte[20];
        System.arraycopy(byArray4, 12, byArray5, 0, 20);
        StringBuilder stringBuilder = new StringBuilder("0x");
        for (byte by : byArray5) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }

    public static String getTronAddressString(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getBitcoinUncompressedPubKey(byArray);
        int n = 65;
        byte[] byArray3 = new byte[64];
        System.arraycopy(byArray2, 1, byArray3, 0, 64);
        Keccak.Digest256 digest256 = new Keccak.Digest256();
        byte[] byArray4 = digest256.digest(byArray3);
        byte[] byArray5 = new byte[20];
        System.arraycopy(byArray4, 12, byArray5, 0, 20);
        byte[] byArray6 = new byte[byArray5.length + 1];
        byte[] byArray7 = new byte[byArray5.length + 1 + 4];
        byArray6[0] = n;
        System.arraycopy(byArray5, 0, byArray6, 1, byArray5.length);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray8 = messageDigest.digest(byArray6);
            byte[] byArray9 = messageDigest.digest(byArray8);
            byArray7[0] = n;
            System.arraycopy(byArray5, 0, byArray7, 1, byArray5.length);
            System.arraycopy(byArray9, 0, byArray7, byArray5.length + 1, 4);
            String string = PrivateKeyFunctions.encodeBaseX(byArray7, BASE58_ALPHABET);
            return string;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String getXRPsecp256k1AddressString(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getBitcoinCompressedPubKey(byArray);
        byte[] byArray3 = PrivateKeyFunctions.gethash160(byArray2);
        byte[] byArray4 = new byte[byArray3.length + 1];
        byArray4[0] = 0;
        System.arraycopy(byArray3, 0, byArray4, 1, byArray3.length);
        byte[] byArray5 = PrivateKeyFunctions.doubleSHA256(byArray4);
        byte[] byArray6 = new byte[byArray4.length + 4];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        for (int i = 0; i < 4; ++i) {
            byArray6[byArray6.length - 4 + i] = byArray5[i];
        }
        String string = PrivateKeyFunctions.encodeBaseX(byArray6, XRP_BASE_58_ALPHABET);
        return string;
    }

    public static String getXRPED25519PubKeyString(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getED25519EncodedPubKey(byArray);
        byte[] byArray3 = new byte[byArray2.length + 1];
        byArray3[0] = -19;
        System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
        return "0x" + PrivateKeyFunctions.bytesToHex(byArray3);
    }

    public static String getXRPED25519AddressString(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getED25519EncodedPubKey(byArray);
        byte[] byArray3 = PrivateKeyFunctions.gethash160(byArray2);
        byte[] byArray4 = new byte[byArray3.length + 1];
        byArray4[0] = 0;
        System.arraycopy(byArray3, 0, byArray4, 1, byArray3.length);
        byte[] byArray5 = PrivateKeyFunctions.doubleSHA256(byArray4);
        byte[] byArray6 = new byte[byArray4.length + 4];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        for (int i = 0; i < 4; ++i) {
            byArray6[byArray6.length - 4 + i] = byArray5[i];
        }
        String string = PrivateKeyFunctions.encodeBaseX(byArray6, XRP_BASE_58_ALPHABET);
        return string;
    }

    public static String getSolanaAddressString(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getED25519EncodedPubKey(byArray);
        String string = PrivateKeyFunctions.encodeBaseX(byArray2, BASE58_ALPHABET);
        return string;
    }

    private static byte[] doubleSHA256(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            byte[] byArray3 = messageDigest.digest(byArray2);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static byte[] getED25519PubKeyY(byte[] byArray) {
        byte[] byArray2 = PrivateKeyFunctions.getED25519EncodedPubKey(byArray);
        byte[] byArray3 = Arrays.copyOf(byArray2, 32);
        byArray3[31] = (byte)(byArray3[31] & 0x7F);
        byte[] byArray4 = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray4[i] = byArray3[31 - i];
        }
        return byArray4;
    }

    public static byte[] getED25519EncodedPubKey(byte[] byArray) {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(byArray, 0);
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = ed25519PrivateKeyParameters.generatePublicKey();
        byte[] byArray2 = ed25519PublicKeyParameters.getEncoded();
        return byArray2;
    }

    public static BigInteger decodeLittleEndian(byte[] byArray) {
        byte[] byArray2 = (byte[])byArray.clone();
        for (int i = 0; i < byArray2.length / 2; ++i) {
            byte by = byArray2[i];
            byArray2[i] = byArray2[byArray2.length - 1 - i];
            byArray2[byArray2.length - 1 - i] = by;
        }
        return new BigInteger(1, byArray2);
    }

    public static byte[] encodeLittleEndian(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n && i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - 1 - i];
        }
        return byArray2;
    }

    public static byte[] getED25519PubKeyX(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(byArray, 0);
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = ed25519PrivateKeyParameters.generatePublicKey();
        byte[] byArray2 = ed25519PublicKeyParameters.getEncoded();
        boolean bl = (byArray2[31] & 0x80) != 0;
        BigInteger bigInteger3 = BigInteger.valueOf(2L).pow(255).subtract(BigInteger.valueOf(19L));
        BigInteger bigInteger4 = new BigInteger("-121665").multiply(new BigInteger("121666").modInverse(bigInteger3)).mod(bigInteger3);
        byte[] byArray3 = (byte[])byArray2.clone();
        byArray3[31] = (byte)(byArray3[31] & 0x7F);
        BigInteger bigInteger5 = PrivateKeyFunctions.decodeLittleEndian(byArray3);
        BigInteger bigInteger6 = bigInteger5.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger6.subtract(BigInteger.ONE).mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger7.multiply(bigInteger2 = (bigInteger = bigInteger4.multiply(bigInteger6).add(BigInteger.ONE).mod(bigInteger3)).modInverse(bigInteger3)).mod(bigInteger3);
        BigInteger bigInteger9 = PrivateKeyFunctions.sqrtModP(bigInteger8);
        if (bigInteger9 == null) {
            throw new IllegalArgumentException("No square root found for x\u00b2.");
        }
        if (bigInteger9.testBit(0) != bl) {
            bigInteger9 = bigInteger3.subtract(bigInteger9);
        }
        return PrivateKeyFunctions.bigIntTo32Bytes(bigInteger9);
    }

    private static BigInteger sqrtModP(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.valueOf(2L).pow(255).subtract(BigInteger.valueOf(19L));
        BigInteger bigInteger3 = bigInteger2.add(BigInteger.valueOf(3L)).divide(BigInteger.valueOf(8L));
        BigInteger bigInteger4 = bigInteger.modPow(bigInteger3, bigInteger2);
        if (bigInteger4.multiply(bigInteger4).mod(bigInteger2).compareTo(bigInteger) == 0) {
            return bigInteger4;
        }
        BigInteger bigInteger5 = BigInteger.valueOf(2L).modPow(bigInteger2.subtract(BigInteger.ONE).divide(BigInteger.valueOf(4L)), bigInteger2);
        if ((bigInteger4 = bigInteger4.multiply(bigInteger5).mod(bigInteger2)).multiply(bigInteger4).mod(bigInteger2).compareTo(bigInteger) == 0) {
            return bigInteger4;
        }
        return null;
    }
}

