/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;

public class Bech32Encoder {
    private static final String BECH32_ALPHABET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private String hrp_string;
    private String data_string;
    private String full_string;
    private byte version;
    private byte[] checksum;
    private byte[] data_bytes;
    private byte[] witness_program;

    public Bech32Encoder(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string2;
        String string3;
        this.full_string = string;
        int n7 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '1') continue;
            n7 = i;
        }
        if (n7 == 0) {
            throw new IllegalArgumentException("Failed to parse address");
        }
        this.hrp_string = string3 = string.substring(0, n7);
        this.data_string = string2 = string.substring(n7 + 1);
        if (string3.length() == 0 || string2.length() == 0) {
            throw new IllegalArgumentException("Failed to parse address");
        }
        int[] nArray = new int[string2.length()];
        for (n6 = 0; n6 < string2.length(); ++n6) {
            n5 = string2.charAt(n6);
            for (n4 = 0; n4 < BECH32_ALPHABET.length(); ++n4) {
                if (BECH32_ALPHABET.charAt(n4) != n5) continue;
                nArray[n6] = n4;
            }
        }
        if (nArray.length < 8) {
            throw new IllegalArgumentException("Address too short for Bech32");
        }
        this.version = (byte)(nArray[0] & 0xFF);
        this.checksum = new byte[6];
        n6 = 0;
        for (n5 = nArray.length - 6; n5 < nArray.length; ++n5) {
            this.checksum[n6] = (byte)(nArray[n5] & 0xFF);
            ++n6;
        }
        int[] nArray2 = new int[string3.length() * 2 + 1];
        nArray2[string3.length()] = 0;
        for (n4 = 0; n4 < string3.length(); ++n4) {
            n2 = n3 = string3.charAt(n4);
            n = (n2 & 0xE0) >> 5;
            int n8 = n2 & 0x1F;
            nArray2[n4] = n;
            nArray2[string3.length() + 1 + n4] = n8;
        }
        int[] nArray3 = new int[nArray.length - 7];
        for (n3 = 1; n3 < nArray.length - 6; ++n3) {
            nArray3[n3 - '\u0001'] = nArray[n3];
        }
        try {
            this.witness_program = Bech32Encoder.convertBits(nArray3, 5, 8, false);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error converting bits for witness program", exception);
        }
        int[] nArray4 = new int[nArray2.length + 1 + nArray3.length + 6];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray4[n2] = nArray2[n2];
        }
        nArray4[nArray2.length] = this.version;
        for (n2 = nArray2.length + 1; n2 < nArray2.length + 1 + nArray3.length; ++n2) {
            nArray4[n2] = nArray3[n2 - nArray2.length - 1];
        }
        for (n2 = nArray4.length - 6; n2 < nArray4.length; ++n2) {
            nArray4[n2] = 0;
        }
        int[] nArray5 = Bech32Encoder.getBech32ChecksumArray(nArray4, this.version);
        for (n = 0; n < 6; ++n) {
            if ((byte)(nArray5[n] & 0xFF) == this.checksum[n]) continue;
            throw new IllegalArgumentException("Checksum error.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public Bech32Encoder(String string, byte[] byArray, byte by) {
        void var11_17;
        void var11_15;
        int n;
        this.hrp_string = string;
        this.version = by;
        int[] nArray = Bech32Encoder.seperateHRPintoFiveBitArray(string);
        int n3 = 0;
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (byte n22 : byArray) {
            int n2 = n22 & 0xFF;
            n3 = n3 << 8 | n2;
            n4 += 8;
            while (n4 > 5) {
                byteArrayOutputStream.write(n3 >> n4 - 5 & 0x1F);
                n4 -= 5;
            }
        }
        if (n4 != 0) {
            byteArrayOutputStream.write(n3 << 5 - n4 & 0x1F);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int[] nArray2 = new int[nArray.length + byArray2.length + 7];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = this.version;
        for (n = 0; n < byArray2.length; ++n) {
            nArray2[nArray.length + 1 + n] = byArray2[n] & 0xFF;
        }
        for (n = 0; n < 6; ++n) {
            nArray2[byArray2.length + nArray.length + 1 + n] = 0;
        }
        this.checksum = new byte[6];
        int[] nArray3 = new int[6];
        nArray3 = Bech32Encoder.getBech32ChecksumArray(nArray2, this.version);
        boolean bl = false;
        while (var11_15 < 6) {
            this.checksum[var11_15] = (byte)(nArray3[var11_15] & 0xFF);
            ++var11_15;
        }
        this.data_bytes = new byte[1 + byArray2.length + 6];
        this.data_bytes[0] = this.version;
        System.arraycopy(byArray2, 0, this.data_bytes, 1, byArray2.length);
        boolean bl2 = false;
        while (var11_17 < 6) {
            this.data_bytes[byArray2.length + 1 + var11_17] = (byte)(nArray3[var11_17] & 0xFF);
            ++var11_17;
        }
        this.data_string = Bech32Encoder.toBechChars(this.data_bytes);
        this.full_string = this.hrp_string + "1" + this.data_string;
    }

    public String getAddress() {
        return this.full_string;
    }

    public byte[] getWitnessProgram() {
        return this.witness_program;
    }

    public byte getVersion() {
        return this.version;
    }

    private static String toBechChars(byte[] byArray) {
        Object object = "";
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) > 31) {
                return "Data Parsing Error";
            }
            object = (String)object + BECH32_ALPHABET.charAt(byArray[i] & 0xFF);
        }
        return object;
    }

    private static int[] getBech32ChecksumArray(int[] nArray, int n) {
        int n2 = 1;
        int n3 = 996825010;
        int n4 = 642813549;
        int n5 = 513874426;
        int n6 = 1027748829;
        int n7 = 705979059;
        for (int i = 0; i < nArray.length; ++i) {
            int n8 = n2 >>> 25 & 0x1F;
            int n9 = n2 & 0x1FFFFFF;
            int n10 = n9 << 5;
            int n11 = n10 ^ nArray[i] & 0x1F;
            int n12 = n8 & 1;
            if (n12 != 0) {
                n11 ^= n3;
            }
            if ((n12 = n8 & 2) != 0) {
                n11 ^= n4;
            }
            if ((n12 = n8 & 4) != 0) {
                n11 ^= n5;
            }
            if ((n12 = n8 & 8) != 0) {
                n11 ^= n6;
            }
            if ((n12 = n8 & 0x10) != 0) {
                n11 ^= n7;
            }
            n2 = n11;
        }
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            n2 ^= 1;
        }
        if (n > 0) {
            n2 ^= 0x2BC830A3;
        }
        int[] nArray2 = new int[]{(n2 & 0x3E000000) >> 25, (n2 & 0x1F00000) >> 20, (n2 & 0xF8000) >> 15, (n2 & 0x7C00) >> 10, (n2 & 0x3E0) >> 5, n2 & 0x1F};
        return nArray2;
    }

    private static byte[] gethash160(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            RIPEMD160Digest rIPEMD160Digest = new RIPEMD160Digest();
            rIPEMD160Digest.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[rIPEMD160Digest.getDigestSize()];
            rIPEMD160Digest.doFinal(byArray3, 0);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static int[] seperateHRPintoFiveBitArray(String string) {
        int n;
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            nArray[i] = string.charAt(i);
        }
        int[] nArray2 = new int[string.length() * 2 + 1];
        for (n = 0; n < string.length(); ++n) {
            nArray2[n] = (0xE0 & nArray[n]) >> 5;
        }
        nArray2[string.length()] = 0;
        for (n = 0; n < string.length(); ++n) {
            nArray2[string.length() + 1 + n] = 0x1F & nArray[n];
        }
        return nArray2;
    }

    private static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }

    public static byte[] convertBits(int[] nArray, int n, int n2, boolean bl) throws Exception {
        int n3 = 0;
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n5 = (1 << n2) - 1;
        for (int n6 : nArray) {
            if (n6 < 0 || n6 >> n != 0) {
                throw new IllegalArgumentException("Invalid input value: " + n6);
            }
            n3 = n3 << n | n6;
            n4 += n;
            while (n4 >= n2) {
                byteArrayOutputStream.write(n3 >> (n4 -= n2) & n5);
            }
        }
        if (bl) {
            if (n4 > 0) {
                byteArrayOutputStream.write(n3 << n2 - n4 & n5);
            }
        } else if (n4 >= n || (n3 << n2 - n4 & n5) != 0) {
            throw new IllegalArgumentException("Could not convert bits properly");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

