/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.Socket;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONObject;

public class ElectrumClient {
    private static final String HOST = "electrum.blockstream.info";
    private static final int PORT = 50002;

    public static Map<String, String> getBalances(List<String> list) throws Exception {
        Object object;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String object32 : list) {
            object2 = ElectrumClient.getScriptPubKey(object32);
            object = ElectrumClient.computeScripthash((String)object2);
            hashMap2.put(object32, (String)object);
        }
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try (Socket socket = sSLSocketFactory.createSocket(HOST, 50002);){
            object2 = new PrintWriter(socket.getOutputStream(), true);
            try {
                object = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                try {
                    Object object3;
                    int n = 1;
                    for (String string : hashMap2.values()) {
                        object3 = new JSONObject();
                        ((JSONObject)object3).put("id", n++);
                        ((JSONObject)object3).put("method", "blockchain.scripthash.get_balance");
                        ((JSONObject)object3).put("params", Collections.singletonList(string));
                        ((PrintWriter)object2).println(((JSONObject)object3).toString());
                    }
                    n = 1;
                    for (String string : hashMap2.keySet()) {
                        object3 = ((BufferedReader)object).readLine();
                        JSONObject jSONObject = new JSONObject((String)object3);
                        JSONObject jSONObject2 = jSONObject.getJSONObject("result");
                        long l = jSONObject2.getLong("confirmed");
                        long l2 = jSONObject2.getLong("unconfirmed");
                        BigDecimal bigDecimal = new BigDecimal("100000000");
                        BigDecimal bigDecimal2 = new BigDecimal(l).divide(bigDecimal, 8, RoundingMode.DOWN);
                        BigDecimal bigDecimal3 = new BigDecimal(l2).divide(bigDecimal, 8, RoundingMode.DOWN);
                        String string2 = String.format("%s BTC (conf) / %s BTC (unconf)", bigDecimal2.toPlainString(), bigDecimal3.toPlainString());
                        hashMap.put(string, string2);
                        ++n;
                    }
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            finally {
                ((PrintWriter)object2).close();
            }
        }
        return hashMap;
    }

    private static String getScriptPubKey(String string) throws Exception {
        if (string.startsWith("1")) {
            byte[] byArray = Base58Check.decode(string);
            byte[] byArray2 = Arrays.copyOfRange(byArray, 1, 21);
            return "76a914" + ElectrumClient.bytesToHex(byArray2) + "88ac";
        }
        if (string.startsWith("3")) {
            byte[] byArray = Base58Check.decode(string);
            byte[] byArray3 = Arrays.copyOfRange(byArray, 1, 21);
            return "a914" + ElectrumClient.bytesToHex(byArray3) + "87";
        }
        if (string.startsWith("bc1")) {
            try {
                Bech32Encoder bech32Encoder = new Bech32Encoder(string);
                byte by = bech32Encoder.getVersion();
                byte[] byArray = bech32Encoder.getWitnessProgram();
                String string2 = String.format("%02x", by);
                String string3 = String.format("%02x", byArray.length);
                return string2 + string3 + ElectrumClient.bytesToHex(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Unknown address type: " + string);
            }
        }
        throw new IllegalArgumentException("Unknown address type: " + string);
    }

    private static String computeScripthash(String string) throws Exception {
        byte[] byArray = ElectrumClient.hexToBytes(string);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray2 = messageDigest.digest(byArray);
        for (int i = 0; i < byArray2.length / 2; ++i) {
            byte by = byArray2[i];
            byArray2[i] = byArray2[byArray2.length - 1 - i];
            byArray2[byArray2.length - 1 - i] = by;
        }
        return ElectrumClient.bytesToHex(byArray2);
    }

    private static byte[] hexToBytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    private static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", by & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static class Base58Check {
        private static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";

        /*
         * WARNING - void declaration
         */
        public static byte[] decode(String string) throws Exception {
            char c;
            void var5_10;
            byte[] byArray = BigInteger.ZERO.toByteArray();
            for (char c2 : string.toCharArray()) {
                int n = ALPHABET.indexOf(c2);
                if (n == -1) {
                    throw new IllegalArgumentException("Invalid character: " + c2);
                }
                byArray = Base58Check.multiply(byArray, 58);
                byArray = Base58Check.add(byArray, n);
            }
            int n = 0;
            char[] objectArray = string.toCharArray();
            int n2 = objectArray.length;
            boolean bl = false;
            while (var5_10 < n2 && (c = objectArray[var5_10]) == '1') {
                ++n;
                ++var5_10;
            }
            byte[] byArray2 = new byte[n + byArray.length];
            System.arraycopy(byArray, 0, byArray2, n, byArray.length);
            return byArray2;
        }

        private static byte[] multiply(byte[] byArray, int n) {
            BigInteger bigInteger = new BigInteger(1, byArray);
            return bigInteger.multiply(BigInteger.valueOf(n)).toByteArray();
        }

        private static byte[] add(byte[] byArray, int n) {
            BigInteger bigInteger = new BigInteger(1, byArray);
            return bigInteger.add(BigInteger.valueOf(n)).toByteArray();
        }
    }
}

