/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.ECPoint;

public class ExtendedPrivateKey {
    private final BigInteger privateKey;
    private final byte[] chainCode;

    public ExtendedPrivateKey(BigInteger bigInteger, byte[] byArray) {
        this.privateKey = bigInteger;
        this.chainCode = byArray;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPrivateKeyBytes() {
        byte[] byArray = this.privateKey.toByteArray();
        if (byArray.length == 33 && byArray[0] == 0) {
            byArray = Arrays.copyOfRange(byArray, 1, 33);
        } else if (byArray.length < 32) {
            byte[] byArray2 = new byte[32];
            System.arraycopy(byArray, 0, byArray2, 32 - byArray.length, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }

    public byte[] getChainCode() {
        return this.chainCode;
    }

    public ExtendedPrivateKey deriveHardened(int n) {
        int n2 = n | Integer.MIN_VALUE;
        byte[] byArray = new byte[37];
        byArray[0] = 0;
        byte[] byArray2 = this.privateKey.toByteArray();
        if (byArray2.length > 32) {
            System.arraycopy(byArray2, byArray2.length - 32, byArray, 1, 32);
        } else {
            System.arraycopy(byArray2, 0, byArray, 1 + (32 - byArray2.length), byArray2.length);
        }
        byArray[33] = (byte)(n2 >> 24 & 0xFF);
        byArray[34] = (byte)(n2 >> 16 & 0xFF);
        byArray[35] = (byte)(n2 >> 8 & 0xFF);
        byArray[36] = (byte)(n2 & 0xFF);
        byte[] byArray3 = ExtendedPrivateKey.hmacSha512(this.chainCode, byArray);
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        System.arraycopy(byArray3, 0, byArray4, 0, 32);
        System.arraycopy(byArray3, 32, byArray5, 0, 32);
        BigInteger bigInteger = new BigInteger(1, byArray4);
        BigInteger bigInteger2 = bigInteger.add(this.privateKey).mod(CustomNamedCurves.getByName("secp256k1").getN());
        return new ExtendedPrivateKey(bigInteger2, byArray5);
    }

    public ExtendedPrivateKey derive(int n) {
        byte[] byArray = this.getPublicKeyBytesCompressed();
        byte[] byArray2 = new byte[37];
        System.arraycopy(byArray, 0, byArray2, 0, 33);
        byArray2[33] = (byte)(n >> 24 & 0xFF);
        byArray2[34] = (byte)(n >> 16 & 0xFF);
        byArray2[35] = (byte)(n >> 8 & 0xFF);
        byArray2[36] = (byte)(n & 0xFF);
        byte[] byArray3 = ExtendedPrivateKey.hmacSha512(this.chainCode, byArray2);
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        System.arraycopy(byArray3, 0, byArray4, 0, 32);
        System.arraycopy(byArray3, 32, byArray5, 0, 32);
        BigInteger bigInteger = new BigInteger(1, byArray4);
        BigInteger bigInteger2 = bigInteger.add(this.privateKey).mod(CustomNamedCurves.getByName("secp256k1").getN());
        return new ExtendedPrivateKey(bigInteger2, byArray5);
    }

    public byte[] getPublicKeyBytesCompressed() {
        ECPoint eCPoint = CustomNamedCurves.getByName("secp256k1").getG();
        ECPoint eCPoint2 = eCPoint.multiply(this.privateKey).normalize();
        return eCPoint2.getEncoded(true);
    }

    public String getPrivateKeyHex() {
        byte[] byArray = this.privateKey.toByteArray();
        if (byArray.length > 32) {
            byte[] byArray2 = new byte[32];
            System.arraycopy(byArray, byArray.length - 32, byArray2, 0, 32);
            byArray = byArray2;
        }
        return ExtendedPrivateKey.bytesToHex(byArray);
    }

    public String getPublicKeyHex() {
        return ExtendedPrivateKey.bytesToHex(this.getPublicKeyBytesCompressed());
    }

    private static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }

    private static byte[] hmacSha512(byte[] byArray, byte[] byArray2) {
        HMac hMac = new HMac(new SHA512Digest());
        hMac.init(new KeyParameter(byArray));
        hMac.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[64];
        hMac.doFinal(byArray3, 0);
        return byArray3;
    }
}

