/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.ECPoint;

public class WalletKeyFunctions {
    private static final String BASE58_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final String BECH32_ALPHABET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";

    public WalletKeys deriveRootKeys(String string, String string2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        WalletKeys walletKeys = new WalletKeys();
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), ("mnemonic" + string2).getBytes(StandardCharsets.UTF_8), 2048, 512);
        byte[] byArray = secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
        walletKeys.seedHex = WalletKeyFunctions.bytesToHex(byArray);
        byte[] byArray2 = WalletKeyFunctions.hmacSha512("Bitcoin seed".getBytes(StandardCharsets.UTF_8), byArray);
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        System.arraycopy(byArray2, 0, byArray3, 0, 32);
        System.arraycopy(byArray2, 32, byArray4, 0, 32);
        walletKeys.masterPrivateKey = WalletKeyFunctions.bytesToHex(byArray3);
        walletKeys.masterChainCode = WalletKeyFunctions.bytesToHex(byArray4);
        ECPoint eCPoint = CustomNamedCurves.getByName("secp256k1").getG();
        BigInteger bigInteger = new BigInteger(1, byArray3);
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        byte[] byArray5 = eCPoint2.getEncoded(true);
        walletKeys.masterPublicKey = WalletKeyFunctions.bytesToHex(byArray5);
        byte[] byArray6 = new byte[]{4, -120, -83, -28};
        byte[] byArray7 = new byte[]{4, -120, -78, 30};
        byte[] byArray8 = new byte[]{4, -99, 120, 120};
        byte[] byArray9 = new byte[]{4, -99, 124, -78};
        byte[] byArray10 = new byte[]{4, -78, 67, 12};
        byte[] byArray11 = new byte[]{4, -78, 71, 70};
        byte by = 0;
        byte[] byArray12 = new byte[4];
        byte[] byArray13 = new byte[4];
        byte[] byArray14 = byArray4;
        byte[] byArray15 = new byte[33];
        byArray15[0] = 0;
        System.arraycopy(byArray3, 0, byArray15, 1, 32);
        byte[] byArray16 = new byte[33];
        System.arraycopy(byArray5, 0, byArray16, 0, 33);
        byte[] byArray17 = new byte[78];
        byte[] byArray18 = new byte[78];
        byte[] byArray19 = new byte[78];
        System.arraycopy(byArray6, 0, byArray17, 0, 4);
        System.arraycopy(byArray8, 0, byArray18, 0, 4);
        System.arraycopy(byArray10, 0, byArray19, 0, 4);
        byte[] byArray20 = new byte[78];
        byte[] byArray21 = new byte[78];
        byte[] byArray22 = new byte[78];
        System.arraycopy(byArray7, 0, byArray20, 0, 4);
        System.arraycopy(byArray9, 0, byArray21, 0, 4);
        System.arraycopy(byArray11, 0, byArray22, 0, 4);
        byArray17[4] = by;
        byArray18[4] = by;
        byArray19[4] = by;
        byArray20[4] = by;
        byArray21[4] = by;
        byArray22[4] = by;
        System.arraycopy(byArray12, 0, byArray17, 5, 4);
        System.arraycopy(byArray12, 0, byArray18, 5, 4);
        System.arraycopy(byArray12, 0, byArray19, 5, 4);
        System.arraycopy(byArray12, 0, byArray20, 5, 4);
        System.arraycopy(byArray12, 0, byArray21, 5, 4);
        System.arraycopy(byArray12, 0, byArray22, 5, 4);
        System.arraycopy(byArray13, 0, byArray17, 9, 4);
        System.arraycopy(byArray13, 0, byArray18, 9, 4);
        System.arraycopy(byArray13, 0, byArray19, 9, 4);
        System.arraycopy(byArray13, 0, byArray20, 9, 4);
        System.arraycopy(byArray13, 0, byArray21, 9, 4);
        System.arraycopy(byArray13, 0, byArray22, 9, 4);
        System.arraycopy(byArray14, 0, byArray20, 13, 32);
        System.arraycopy(byArray14, 0, byArray21, 13, 32);
        System.arraycopy(byArray14, 0, byArray22, 13, 32);
        System.arraycopy(byArray14, 0, byArray17, 13, 32);
        System.arraycopy(byArray14, 0, byArray18, 13, 32);
        System.arraycopy(byArray14, 0, byArray19, 13, 32);
        System.arraycopy(byArray16, 0, byArray20, 45, 33);
        System.arraycopy(byArray16, 0, byArray21, 45, 33);
        System.arraycopy(byArray16, 0, byArray22, 45, 33);
        System.arraycopy(byArray15, 0, byArray17, 45, 33);
        System.arraycopy(byArray15, 0, byArray18, 45, 33);
        System.arraycopy(byArray15, 0, byArray19, 45, 33);
        byte[] byArray23 = WalletKeyFunctions.getDoubleSHA256Checksum(byArray17);
        byte[] byArray24 = new byte[byArray17.length + 4];
        System.arraycopy(byArray17, 0, byArray24, 0, byArray17.length);
        System.arraycopy(byArray23, 0, byArray24, byArray17.length, 4);
        byArray23 = WalletKeyFunctions.getDoubleSHA256Checksum(byArray18);
        byte[] byArray25 = new byte[byArray18.length + 4];
        System.arraycopy(byArray18, 0, byArray25, 0, byArray18.length);
        System.arraycopy(byArray23, 0, byArray25, byArray18.length, 4);
        byArray23 = WalletKeyFunctions.getDoubleSHA256Checksum(byArray19);
        byte[] byArray26 = new byte[byArray19.length + 4];
        System.arraycopy(byArray19, 0, byArray26, 0, byArray19.length);
        System.arraycopy(byArray23, 0, byArray26, byArray19.length, 4);
        byArray23 = WalletKeyFunctions.getDoubleSHA256Checksum(byArray20);
        byte[] byArray27 = new byte[byArray20.length + 4];
        System.arraycopy(byArray20, 0, byArray27, 0, byArray20.length);
        System.arraycopy(byArray23, 0, byArray27, byArray20.length, 4);
        byArray23 = WalletKeyFunctions.getDoubleSHA256Checksum(byArray21);
        byte[] byArray28 = new byte[byArray21.length + 4];
        System.arraycopy(byArray21, 0, byArray28, 0, byArray21.length);
        System.arraycopy(byArray23, 0, byArray28, byArray21.length, 4);
        byArray23 = WalletKeyFunctions.getDoubleSHA256Checksum(byArray22);
        byte[] byArray29 = new byte[byArray22.length + 4];
        System.arraycopy(byArray22, 0, byArray29, 0, byArray22.length);
        System.arraycopy(byArray23, 0, byArray29, byArray22.length, 4);
        walletKeys.xpriv = WalletKeyFunctions.encodeBaseX(byArray24, BASE58_ALPHABET);
        walletKeys.ypriv = WalletKeyFunctions.encodeBaseX(byArray25, BASE58_ALPHABET);
        walletKeys.zpriv = WalletKeyFunctions.encodeBaseX(byArray26, BASE58_ALPHABET);
        walletKeys.xpub = WalletKeyFunctions.encodeBaseX(byArray27, BASE58_ALPHABET);
        walletKeys.ypub = WalletKeyFunctions.encodeBaseX(byArray28, BASE58_ALPHABET);
        walletKeys.zpub = WalletKeyFunctions.encodeBaseX(byArray29, BASE58_ALPHABET);
        walletKeys.extendedPrivateKey = new ExtendedPrivateKey(bigInteger, byArray14);
        return walletKeys;
    }

    public WalletKeys deriveAllAccountLevelKeys(String string, String string2) throws NoSuchAlgorithmException {
        WalletKeys walletKeys;
        try {
            walletKeys = this.deriveRootKeys(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
        int[] nArray = new int[]{44, 49, 84};
        String[] stringArray = new String[]{"xpub", "ypub", "zpub"};
        byte[] byArray = WalletKeyFunctions.calculateParentFingerprint(walletKeys.extendedPrivateKey.getPublicKeyBytesCompressed());
        WalletKeys walletKeys2 = new WalletKeys();
        walletKeys2.extendedPrivateKey = walletKeys.extendedPrivateKey;
        for (int i = 0; i < nArray.length; ++i) {
            byte[] byArray2;
            byte[] byArray3;
            int n = nArray[i];
            String string3 = stringArray[i];
            ExtendedPrivateKey extendedPrivateKey = walletKeys.extendedPrivateKey.deriveHardened(n).deriveHardened(0).deriveHardened(0);
            byte[] byArray4 = extendedPrivateKey.getPrivateKeyBytes();
            byte[] byArray5 = extendedPrivateKey.getChainCode();
            byte[] byArray6 = extendedPrivateKey.getPublicKeyBytesCompressed();
            if (string3.equals("xpub")) {
                byArray3 = new byte[]{4, -120, -78, 30};
                byArray2 = new byte[]{4, -120, -83, -28};
            } else if (string3.equals("ypub")) {
                byArray3 = new byte[]{4, -99, 124, -78};
                byArray2 = new byte[]{4, -99, 120, 120};
            } else {
                byArray3 = new byte[]{4, -78, 71, 70};
                byArray2 = new byte[]{4, -78, 67, 12};
            }
            int n2 = 3;
            byte[] byArray7 = new byte[]{0, 0, 0, 0};
            byte[] byArray8 = new byte[33];
            byArray8[0] = 0;
            System.arraycopy(byArray4, 0, byArray8, 1, 32);
            byte[] byArray9 = new byte[78];
            System.arraycopy(byArray2, 0, byArray9, 0, 4);
            byArray9[4] = n2;
            System.arraycopy(byArray, 0, byArray9, 5, 4);
            System.arraycopy(byArray7, 0, byArray9, 9, 4);
            System.arraycopy(byArray5, 0, byArray9, 13, 32);
            System.arraycopy(byArray8, 0, byArray9, 45, 33);
            byte[] byArray10 = new byte[78];
            System.arraycopy(byArray3, 0, byArray10, 0, 4);
            byArray10[4] = n2;
            System.arraycopy(byArray, 0, byArray10, 5, 4);
            System.arraycopy(byArray7, 0, byArray10, 9, 4);
            System.arraycopy(byArray5, 0, byArray10, 13, 32);
            System.arraycopy(byArray6, 0, byArray10, 45, 33);
            byte[] byArray11 = WalletKeyFunctions.getDoubleSHA256Checksum(byArray9);
            byte[] byArray12 = new byte[byArray9.length + 4];
            System.arraycopy(byArray9, 0, byArray12, 0, byArray9.length);
            System.arraycopy(byArray11, 0, byArray12, byArray9.length, 4);
            String string4 = WalletKeyFunctions.encodeBaseX(byArray12, BASE58_ALPHABET);
            byArray11 = WalletKeyFunctions.getDoubleSHA256Checksum(byArray10);
            byArray12 = new byte[byArray10.length + 4];
            System.arraycopy(byArray10, 0, byArray12, 0, byArray10.length);
            System.arraycopy(byArray11, 0, byArray12, byArray10.length, 4);
            String string5 = WalletKeyFunctions.encodeBaseX(byArray12, BASE58_ALPHABET);
            if (string3.equals("xpub")) {
                walletKeys2.xpriv = string4;
                walletKeys2.xpub = string5;
                continue;
            }
            if (string3.equals("ypub")) {
                walletKeys2.ypriv = string4;
                walletKeys2.ypub = string5;
                continue;
            }
            walletKeys2.zpriv = string4;
            walletKeys2.zpub = string5;
        }
        return walletKeys2;
    }

    public static byte[] calculateParentFingerprint(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            RIPEMD160Digest rIPEMD160Digest = new RIPEMD160Digest();
            rIPEMD160Digest.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[20];
            rIPEMD160Digest.doFinal(byArray3, 0);
            return Arrays.copyOfRange(byArray3, 0, 4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new RuntimeException("Error calculating parent fingerprint", noSuchAlgorithmException);
        }
    }

    public ChildKey[] deriveChildKeys(String string, String string2, String string3, int n, int n2) {
        int n3;
        WalletKeys walletKeys;
        try {
            walletKeys = this.deriveRootKeys(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
        if (string3.equalsIgnoreCase("xpub")) {
            n3 = 44;
        } else if (string3.equalsIgnoreCase("ypub")) {
            n3 = 49;
        } else if (string3.equalsIgnoreCase("zpub")) {
            n3 = 84;
        } else {
            throw new IllegalArgumentException("Invalid derivationType: " + string3);
        }
        ExtendedPrivateKey extendedPrivateKey = walletKeys.extendedPrivateKey;
        ExtendedPrivateKey extendedPrivateKey2 = extendedPrivateKey.deriveHardened(n3).deriveHardened(0).deriveHardened(0).derive(0);
        ChildKey[] childKeyArray = new ChildKey[n2 - n];
        for (int i = n; i < n2; ++i) {
            ExtendedPrivateKey extendedPrivateKey3 = extendedPrivateKey2.derive(i);
            ChildKey childKey = new ChildKey();
            childKey.childNumber = i;
            childKey.privateKey = extendedPrivateKey3.getPrivateKeyHex();
            childKey.publicKey = extendedPrivateKey3.getPublicKeyHex();
            childKey.address = this.generateAddress(childKey.publicKey, string3);
            childKey.balance = "0";
            childKeyArray[i - n] = childKey;
        }
        return childKeyArray;
    }

    private static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }

    private static byte[] hmacSha512(byte[] byArray, byte[] byArray2) {
        HMac hMac = new HMac(new SHA512Digest());
        hMac.init(new KeyParameter(byArray));
        hMac.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[64];
        hMac.doFinal(byArray3, 0);
        return byArray3;
    }

    private static String encodeBaseX(byte[] byArray, String string) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        int n = 0;
        for (byte by : byArray) {
            if (by != 0) break;
            ++n;
        }
        Object object = new BigInteger(1, byArray);
        if (((BigInteger)object).equals(BigInteger.ZERO)) {
            return String.valueOf(string.charAt(0));
        }
        StringBuilder stringBuilder = new StringBuilder();
        BigInteger bigInteger = BigInteger.valueOf(string.length());
        while (((BigInteger)object).compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] bigIntegerArray = ((BigInteger)object).divideAndRemainder(bigInteger);
            stringBuilder.insert(0, string.charAt(bigIntegerArray[1].intValue()));
            object = bigIntegerArray[0];
        }
        String string2 = stringBuilder.toString();
        char c = string.charAt(0);
        return String.valueOf(c).repeat(n) + string2;
    }

    private static byte[] getDoubleSHA256Checksum(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray2 = messageDigest.digest(byArray);
        byte[] byArray3 = messageDigest.digest(byArray2);
        byte[] byArray4 = new byte[4];
        System.arraycopy(byArray3, 0, byArray4, 0, 4);
        return byArray4;
    }

    public String generateAddress(String string, String string2) {
        if (string2.equalsIgnoreCase("xpub")) {
            return this.pubKeytoP2PKH(string);
        }
        if (string2.equalsIgnoreCase("ypub")) {
            return this.pubKeytoP2SH(string);
        }
        if (string2.equalsIgnoreCase("zpub")) {
            return this.pubKeytoP2WPKH(string);
        }
        return "Address Error";
    }

    private String pubKeytoP2PKH(String string) {
        byte by = 0;
        byte[] byArray = new byte[25];
        byte[] byArray2 = WalletKeyFunctions.hexStringToByteArray(string);
        byte[] byArray3 = WalletKeyFunctions.gethash160(byArray2);
        byte[] byArray4 = new byte[byArray3.length + 1];
        byArray4[0] = by;
        System.arraycopy(byArray3, 0, byArray4, 1, byArray3.length);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray5 = messageDigest.digest(byArray4);
            byte[] byArray6 = messageDigest.digest(byArray5);
            byArray[0] = by;
            System.arraycopy(byArray3, 0, byArray, 1, byArray3.length);
            for (int i = 0; i < 4; ++i) {
                byArray[21 + i] = byArray6[i];
            }
            return WalletKeyFunctions.encodeBaseX(byArray, BASE58_ALPHABET);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private String pubKeytoP2SH(String string) {
        try {
            byte[] byArray = WalletKeyFunctions.hexStringToByteArray(string);
            byte[] byArray2 = WalletKeyFunctions.gethash160(byArray);
            byte[] byArray3 = new byte[22];
            byArray3[0] = 0;
            byArray3[1] = 20;
            System.arraycopy(byArray2, 0, byArray3, 2, 20);
            byte[] byArray4 = WalletKeyFunctions.gethash160(byArray3);
            byte[] byArray5 = new byte[25];
            byArray5[0] = 5;
            System.arraycopy(byArray4, 0, byArray5, 1, 20);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray6 = new byte[21];
            System.arraycopy(byArray5, 0, byArray6, 0, 21);
            byte[] byArray7 = messageDigest.digest(byArray6);
            byte[] byArray8 = messageDigest.digest(byArray7);
            System.arraycopy(byArray8, 0, byArray5, 21, 4);
            return WalletKeyFunctions.encodeBaseX(byArray5, BASE58_ALPHABET);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    private String pubKeytoP2WPKH(String string) {
        byte[] byArray = WalletKeyFunctions.hexStringToByteArray(string);
        byte[] byArray2 = WalletKeyFunctions.gethash160(byArray);
        Bech32Encoder bech32Encoder = new Bech32Encoder("bc", byArray2, 0);
        return bech32Encoder.getAddress();
    }

    private static byte[] hexStringToByteArray(String object) {
        if (((String)object).length() == 0) {
            return new byte[0];
        }
        if (((String)object).length() % 2 != 0) {
            object = "0" + (String)object;
        }
        int n = ((String)object).length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            int n2 = Character.digit(((String)object).charAt(i), 16);
            int n3 = Character.digit(((String)object).charAt(i + 1), 16);
            byArray[i / 2] = (byte)((n2 << 4) + n3);
        }
        return byArray;
    }

    private static byte[] gethash160(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            RIPEMD160Digest rIPEMD160Digest = new RIPEMD160Digest();
            rIPEMD160Digest.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[rIPEMD160Digest.getDigestSize()];
            rIPEMD160Digest.doFinal(byArray3, 0);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static class WalletKeys {
        public String seedHex;
        public String masterPrivateKey;
        public String masterChainCode;
        public String masterPublicKey;
        public String xpriv;
        public String ypriv;
        public String zpriv;
        public String xpub;
        public String ypub;
        public String zpub;
        public ExtendedPrivateKey extendedPrivateKey;
    }

    public static class ChildKey {
        public int childNumber;
        public String privateKey;
        public String publicKey;
        public String address;
        public String balance;
    }
}

