/*
 * Decompiled with CFR 0.152.
 */
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class WalletView
extends JFrame {
    private final WalletKeyFunctions keyFunctions = new WalletKeyFunctions();
    private int nextChildIndex = 0;
    private JTextArea seedPhraseTextArea;
    private JTextField passphraseField;
    private JButton calculateButton;
    private JButton clearButton;
    private JButton loadNextBatchButton;
    private JTextArea outputTextArea;
    private JTable childKeysTable;
    private DefaultTableModel childKeysTableModel;
    private JComboBox<String> derivationSelector;
    private JCheckBox balanceCheckBox;
    private JSpinner batchSizeSpinner;
    private List<WalletKeyFunctions.ChildKey> derivedChildren = new ArrayList<WalletKeyFunctions.ChildKey>();
    private int currentBatch = 0;
    private String seedPhrase;
    private String passphrase;
    private String derivationType;
    private boolean checkBalance;

    public WalletView() {
        super("Wallet Key Generator");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel("Enter Seed Phrase:");
        this.seedPhraseTextArea = new JTextArea(3, 50);
        this.seedPhraseTextArea.setLineWrap(true);
        this.seedPhraseTextArea.setWrapStyleWord(true);
        this.seedPhraseTextArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.seedPhraseTextArea);
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        JLabel jLabel2 = new JLabel("Enter Passphrase (optional):");
        this.passphraseField = new JTextField(50);
        this.passphraseField.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel3.add((Component)jLabel2, "North");
        jPanel3.add((Component)this.passphraseField, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JLabel jLabel3 = new JLabel("Derivation Type:");
        this.derivationSelector = new JComboBox<String>(new String[]{"xpub: BIP 44 m/44'/0'/0'/0", "ypub BIP 49 m/49'/0'/0'/0", "zpub BIP 84 m/84'/0'/0'/0"});
        JLabel jLabel4 = new JLabel("Batch Size:");
        this.batchSizeSpinner = new JSpinner(new SpinnerNumberModel(10, 5, 20, 5));
        this.balanceCheckBox = new JCheckBox("Enable Balance Checking");
        jPanel4.add(jLabel3);
        jPanel4.add(this.derivationSelector);
        jPanel4.add(jLabel4);
        jPanel4.add(this.batchSizeSpinner);
        jPanel4.add(this.balanceCheckBox);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        this.calculateButton = new JButton("Calculate Root Keys");
        this.clearButton = new JButton("Clear");
        this.loadNextBatchButton = new JButton("Load Next Batch");
        this.loadNextBatchButton.setEnabled(false);
        jPanel5.add(this.calculateButton);
        jPanel5.add(this.loadNextBatchButton);
        jPanel5.add(this.clearButton);
        JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
        JLabel jLabel5 = new JLabel("Derived Root Keys:");
        this.outputTextArea = new JTextArea(6, 50);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane2 = new JScrollPane(this.outputTextArea);
        jPanel6.add((Component)jLabel5, "North");
        jPanel6.add((Component)jScrollPane2, "Center");
        JPanel jPanel7 = new JPanel(new BorderLayout(5, 5));
        JLabel jLabel6 = new JLabel("Child Keys:");
        Object[] objectArray = new String[]{"#", "Keys: Private (top) / Public (bottom)", "Address", "Balance"};
        this.childKeysTableModel = new DefaultTableModel(objectArray, 0);
        this.childKeysTable = new JTable(this.childKeysTableModel);
        this.childKeysTable.getColumnModel().getColumn(1).setCellRenderer(new MultiLineTableCellRenderer());
        TableColumnModel tableColumnModel = this.childKeysTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(25);
        tableColumnModel.getColumn(1).setPreferredWidth(500);
        tableColumnModel.getColumn(2).setPreferredWidth(300);
        tableColumnModel.getColumn(3).setPreferredWidth(300);
        JScrollPane jScrollPane3 = new JScrollPane(this.childKeysTable);
        jPanel7.add((Component)jLabel6, "North");
        jPanel7.add((Component)jScrollPane3, "Center");
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton("Export Selected to .csv");
        JButton jButton2 = new JButton("Export All to .csv");
        jPanel8.add(jButton);
        jPanel8.add(jButton2);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        jPanel.add(jPanel7);
        jPanel.add(jPanel8);
        this.add(jPanel);
        this.calculateButton.addActionListener(this::onCalculateRootKeys);
        this.clearButton.addActionListener(actionEvent -> this.clearFields());
        this.loadNextBatchButton.addActionListener(actionEvent -> this.loadNextBatch());
        this.derivationSelector.addActionListener(actionEvent -> this.clearChildren());
        this.balanceCheckBox.addActionListener(actionEvent -> this.changeBalanceChecking());
        jButton.addActionListener(actionEvent -> this.exportSelectedToCSV());
        jButton2.addActionListener(actionEvent -> this.exportAllToCSV());
        this.setSize(1200, 800);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void onCalculateRootKeys(ActionEvent actionEvent) {
        this.seedPhrase = this.seedPhraseTextArea.getText().trim();
        this.passphrase = this.passphraseField.getText().trim();
        this.derivationType = ((String)this.derivationSelector.getSelectedItem()).substring(0, 4);
        this.checkBalance = this.balanceCheckBox.isSelected();
        if (this.seedPhrase.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Seed phrase is empty.", "Error", 0);
            return;
        }
        String[] stringArray = this.seedPhrase.split("\\s+");
        int n = stringArray.length;
        if (n != 12 && n != 15 && n != 18 && n != 21 && n != 24) {
            JOptionPane.showMessageDialog(this, "Invalid seed phrase length.\nSeed phrase must have 12, 15, 18, 21, or 24 words.\nCurrent count: " + n, "Error", 0);
            return;
        }
        this.outputTextArea.setText("");
        this.clearChildren();
        try {
            WalletKeyFunctions.WalletKeys walletKeys = this.keyFunctions.deriveRootKeys(this.seedPhrase, this.passphrase);
            this.outputTextArea.append("Derivation Elements: \n");
            this.outputTextArea.append("Seed: " + walletKeys.seedHex + "\n");
            this.outputTextArea.append("Master Chain Code: " + walletKeys.masterChainCode + "\n");
            this.outputTextArea.append("Master Private Key: " + walletKeys.masterPrivateKey + "\n");
            this.outputTextArea.append("Master Public Key: " + walletKeys.masterPublicKey + "\n");
            this.outputTextArea.append("\nBitcoin Root Keys: \n");
            this.outputTextArea.append(walletKeys.xpriv + "\n");
            this.outputTextArea.append(walletKeys.xpub + "\n");
            this.outputTextArea.append(walletKeys.ypriv + "\n");
            this.outputTextArea.append(walletKeys.ypub + "\n");
            this.outputTextArea.append(walletKeys.zpriv + "\n");
            this.outputTextArea.append(walletKeys.zpub + "\n");
            WalletKeyFunctions.WalletKeys walletKeys2 = this.keyFunctions.deriveAllAccountLevelKeys(this.seedPhrase, this.passphrase);
            this.outputTextArea.append("\nBitcoin Account Level Keys: \n");
            this.outputTextArea.append(walletKeys2.xpub + "\n");
            this.outputTextArea.append(walletKeys2.ypub + "\n");
            this.outputTextArea.append(walletKeys2.zpub + "\n");
            this.outputTextArea.setCaretPosition(0);
            this.loadNextBatchButton.setEnabled(true);
        }
        catch (Exception exception) {
            this.outputTextArea.append("Error: " + exception.getMessage() + "\n");
            this.loadNextBatchButton.setEnabled(false);
            return;
        }
        this.loadNextBatch();
    }

    private void loadNextBatch() {
        this.derivationType = ((String)this.derivationSelector.getSelectedItem()).substring(0, 4);
        try {
            int n = (Integer)this.batchSizeSpinner.getValue();
            int n2 = this.nextChildIndex;
            int n3 = n2 + n;
            WalletKeyFunctions.ChildKey[] childKeyArray = this.keyFunctions.deriveChildKeys(this.seedPhrase, this.passphrase, this.derivationType, n2, n3);
            if (this.checkBalance) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < childKeyArray.length; ++i) {
                    arrayList.add(childKeyArray[i].address);
                }
                ElectrumClient electrumClient = new ElectrumClient();
                Map<Object, Object> map = new HashMap();
                map = ElectrumClient.getBalances(arrayList);
                for (WalletKeyFunctions.ChildKey childKey : childKeyArray) {
                    String string = (String)map.get(childKey.address);
                    childKey.balance = string != null ? string : "0";
                }
            } else {
                for (WalletKeyFunctions.ChildKey childKey : childKeyArray) {
                    childKey.balance = "Disabled";
                }
            }
            for (WalletKeyFunctions.ChildKey childKey : childKeyArray) {
                this.derivedChildren.add(childKey);
                String string = childKey.privateKey + "\n" + childKey.publicKey;
                this.childKeysTableModel.addRow(new Object[]{childKey.childNumber, string, childKey.address, childKey.balance});
            }
            this.nextChildIndex = n3;
        }
        catch (Exception exception) {
            this.outputTextArea.append("Error: " + exception.getMessage() + "\n");
        }
        this.adjustRowHeights();
        SwingUtilities.invokeLater(() -> {
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.childKeysTable);
            if (jScrollPane != null) {
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getMaximum());
            }
        });
    }

    private void adjustRowHeights() {
        for (int i = 0; i < this.childKeysTable.getRowCount(); ++i) {
            int n = 1;
            for (int j = 0; j < this.childKeysTable.getColumnCount(); ++j) {
                TableCellRenderer tableCellRenderer = this.childKeysTable.getCellRenderer(i, j);
                Component component = this.childKeysTable.prepareRenderer(tableCellRenderer, i, j);
                n = Math.max(n, component.getPreferredSize().height);
            }
            this.childKeysTable.setRowHeight(i, n);
        }
    }

    private void clearChildren() {
        this.childKeysTableModel.setRowCount(0);
        this.derivedChildren.clear();
        this.currentBatch = 0;
        this.nextChildIndex = 0;
    }

    private void clearFields() {
        this.seedPhraseTextArea.setText("");
        this.passphraseField.setText("");
        this.outputTextArea.setText("");
        this.childKeysTableModel.setRowCount(0);
        this.derivedChildren.clear();
        this.currentBatch = 0;
        this.nextChildIndex = 0;
        this.loadNextBatchButton.setEnabled(false);
    }

    private void changeBalanceChecking() {
        this.checkBalance = this.balanceCheckBox.isSelected();
    }

    private void exportSelectedToCSV() {
        int[] nArray = this.childKeysTable.getSelectedRows();
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected to export.", "Export Selected", 2);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Selected Rows as CSV");
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try (PrintWriter printWriter = new PrintWriter(file);){
                printWriter.println("#,Private Key,Public Key,Address,Balance");
                for (int n2 : nArray) {
                    Object object = this.childKeysTable.getValueAt(n2, 0);
                    String string = (String)this.childKeysTable.getValueAt(n2, 1);
                    String[] stringArray = string.split("\n", 2);
                    String string2 = stringArray.length > 0 ? stringArray[0] : "";
                    String string3 = stringArray.length > 1 ? stringArray[1] : "";
                    Object object2 = this.childKeysTable.getValueAt(n2, 2);
                    Object object3 = this.childKeysTable.getValueAt(n2, 3);
                    printWriter.printf("%s,%s,%s,%s,%s%n", object, string2, string3, object2, object3);
                }
                JOptionPane.showMessageDialog(this, "Selected rows exported successfully!", "Export Selected", 1);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error exporting: " + exception.getMessage(), "Error", 0);
            }
        }
    }

    private void exportAllToCSV() {
        int n = this.childKeysTable.getRowCount();
        if (n == 0) {
            JOptionPane.showMessageDialog(this, "No rows to export.", "Export All", 2);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save All Rows as CSV");
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 == 0) {
            File file = jFileChooser.getSelectedFile();
            try (PrintWriter printWriter = new PrintWriter(file);){
                printWriter.println("#,Private Key,Public Key,Address,Balance");
                for (int i = 0; i < n; ++i) {
                    Object object = this.childKeysTable.getValueAt(i, 0);
                    String string = (String)this.childKeysTable.getValueAt(i, 1);
                    String[] stringArray = string.split("\n", 2);
                    String string2 = stringArray.length > 0 ? stringArray[0] : "";
                    String string3 = stringArray.length > 1 ? stringArray[1] : "";
                    Object object2 = this.childKeysTable.getValueAt(i, 2);
                    Object object3 = this.childKeysTable.getValueAt(i, 3);
                    printWriter.printf("%s,%s,%s,%s,%s%n", object, string2, string3, object2, object3);
                }
                JOptionPane.showMessageDialog(this, "All rows exported successfully!", "Export All", 1);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error exporting: " + exception.getMessage(), "Error", 0);
            }
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            FlatLightLaf.setup();
            new WalletView();
        });
    }

    class MultiLineTableCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        public MultiLineTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object != null ? object.toString() : "");
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setFont(jTable.getFont());
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = fontMetrics.getHeight();
            int n4 = n3 * 2 + this.getInsets().top + this.getInsets().bottom;
            if (jTable.getRowHeight(n) != n4) {
                jTable.setRowHeight(n, n4);
            }
            return this;
        }
    }
}

